/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.lang.Assert;
import java.security.Key;
import java.util.function.Function;

public class JwsClaimsExtractor
implements Function<String, Claims> {
    private final Key signingKey;
    private final byte[] signingKeyBytes;
    private final SigningKeyResolver signingKeyResolver;
    private Long allowedClockSkewSeconds;

    public JwsClaimsExtractor() {
        this.signingKey = null;
        this.signingKeyBytes = null;
        this.signingKeyResolver = null;
        this.allowedClockSkewSeconds = null;
    }

    public JwsClaimsExtractor(byte[] hmacSigningKeyBytes) {
        Assert.isTrue((hmacSigningKeyBytes != null && hmacSigningKeyBytes.length > 0 ? 1 : 0) != 0, (String)"hmacSigningKeyByte array argument cannot be null or empty.");
        this.signingKeyBytes = hmacSigningKeyBytes;
        this.signingKey = null;
        this.signingKeyResolver = null;
    }

    public JwsClaimsExtractor(Key key) {
        Assert.notNull((Object)key, (String)"key argument cannot be null.");
        this.signingKey = key;
        this.signingKeyBytes = null;
        this.signingKeyResolver = null;
    }

    public JwsClaimsExtractor(SigningKeyResolver signingKeyResolver) {
        Assert.notNull((Object)signingKeyResolver, (String)"signingKeyResolver argument cannot be null.");
        this.signingKeyResolver = signingKeyResolver;
        this.signingKeyBytes = null;
        this.signingKey = null;
    }

    public JwsClaimsExtractor setAllowedClockSkewSeconds(Long allowedClockSkewSeconds) {
        this.allowedClockSkewSeconds = allowedClockSkewSeconds;
        return this;
    }

    @Override
    public Claims apply(String headerValue) {
        JwtParser parser = Jwts.parser();
        if (this.signingKeyBytes != null) {
            parser.setSigningKey(this.signingKeyBytes);
        } else if (this.signingKey != null) {
            parser.setSigningKey(this.signingKey);
        } else if (this.signingKeyResolver != null) {
            parser.setSigningKeyResolver(this.signingKeyResolver);
        }
        if (this.allowedClockSkewSeconds != null) {
            parser.setAllowedClockSkewSeconds(this.allowedClockSkewSeconds.longValue());
        }
        return (Claims)parser.parseClaimsJws(headerValue).getBody();
    }
}

