/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.jwt.config;

import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.TextCodec;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Classes;
import io.jsonwebtoken.lang.RuntimeEnvironment;
import io.jsonwebtoken.lang.Strings;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.util.function.Function;
import javax.crypto.spec.SecretKeySpec;
import org.juiser.io.DefaultResource;
import org.juiser.io.Resource;
import org.juiser.io.ResourceLoader;
import org.juiser.jwt.AlgorithmFamily;
import org.juiser.jwt.config.JwkConfig;
import org.juiser.jwt.config.PemResourceKeyResolver;

public class ConfigJwkResolver
implements Function<JwkConfig, Key> {
    private final ResourceLoader resourceLoader;

    public ConfigJwkResolver(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader);
        this.resourceLoader = resourceLoader;
    }

    @Override
    public Key apply(JwkConfig jwk) {
        String msg;
        Key key = null;
        AlgorithmFamily algorithmFamily = null;
        String algFamilyName = jwk.getAlgFamily();
        if (Strings.hasText((String)algFamilyName)) {
            try {
                algorithmFamily = AlgorithmFamily.forName(algFamilyName);
            }
            catch (IllegalArgumentException e) {
                String msg2 = "Unsupported juiser.header.jwt.jwk.algFamily value: " + algFamilyName + ".  Please use only " + AlgorithmFamily.class.getName() + " enum names: " + Strings.arrayToCommaDelimitedString((Object[])AlgorithmFamily.values());
                throw new IllegalArgumentException(msg2, e);
            }
        }
        byte[] bytes = null;
        Resource keyResource = this.getResource(jwk);
        String keyString = jwk.getValue();
        boolean keyStringSpecified = Strings.hasText((String)keyString);
        if (keyResource != null && keyStringSpecified) {
            String msg3 = "Both the juiser.header.jwt.key.value and juiser.header.jwt.key.resource properties may not be set simultaneously.  Please choose one.";
            throw new IllegalArgumentException(msg3);
        }
        if (keyStringSpecified) {
            String encoding = jwk.getEncoding();
            if (keyString.startsWith("-----BEGIN ")) {
                encoding = "pem";
            }
            if (encoding == null) {
                encoding = "base64url";
            }
            if (encoding.equalsIgnoreCase("base64url")) {
                bytes = TextCodec.BASE64URL.decode(keyString);
            } else if (encoding.equalsIgnoreCase("base64")) {
                bytes = TextCodec.BASE64.decode(keyString);
            } else if (encoding.equalsIgnoreCase("utf8")) {
                bytes = keyString.getBytes(StandardCharsets.UTF_8);
            } else if (encoding.equalsIgnoreCase("pem")) {
                byte[] resourceBytes = keyString.getBytes(StandardCharsets.UTF_8);
                ByteArrayInputStream bais = new ByteArrayInputStream(resourceBytes);
                keyResource = new DefaultResource(bais, "juiser.header.jwt.key.value");
            } else {
                throw new IllegalArgumentException("Unsupported encoding '" + encoding + "'.  Supported encodings: base64url, base64, utf8, pem.");
            }
        }
        if (bytes != null && bytes.length > 0) {
            if (algorithmFamily == null) {
                algorithmFamily = AlgorithmFamily.HMAC;
            }
            if (!algorithmFamily.equals((Object)AlgorithmFamily.HMAC)) {
                String algFam = algorithmFamily.name();
                msg = "It appears that the juiser.header.jwt.key.value is a shared (symmetric) secret key, and this requires the juiser.header.jwt.key.algFamily value to equal HMAC. The specified juiser.header.jwt.key.algFamily value is " + algFam + ". If you wish to use the " + algFam + " algorithm, please ensure that either 1) juiser.header.jwt.key.value is a public asymmetric PEM-encoded string, or 2) set the juiser.header.jwt.key.resource property to a Resource path where the PEM-encoded public key file resides, or or 3) define a bean named 'juiserForwardedAccountJwtSigningKey' that returns an " + algFam + " private key instance.";
                throw new IllegalArgumentException(msg);
            }
            SignatureAlgorithm alg = ConfigJwkResolver.getAlgorithm(bytes);
            key = new SecretKeySpec(bytes, alg.getJcaName());
        }
        if (keyResource != null) {
            Function<Resource, Key> resourceKeyResolver = this.createResourceKeyFunction(keyResource, keyStringSpecified);
            Assert.notNull(resourceKeyResolver, (String)"resourceKeyResolver instance cannot be null.");
            key = resourceKeyResolver.apply(keyResource);
            if (key == null) {
                msg = "Resource to Key resolver/function did not return a key for specified resource [" + keyResource + "].  If providing your own implementation of this function, ensure it does not return null.";
                throw new IllegalStateException(msg);
            }
            Assert.notNull((Object)key, (String)("ResourceKeyResolver function did not return a key for specified resource [" + keyResource + "]"));
            if (algorithmFamily == null) {
                if (key instanceof RSAKey) {
                    algorithmFamily = AlgorithmFamily.RSA;
                } else if (key instanceof ECKey) {
                    algorithmFamily = AlgorithmFamily.EC;
                } else {
                    msg = "Unable to detect jwt signing key type to provide a default signature algorithm.  Please specify the juiser.header.jwt.key.algFamily property.";
                    throw new IllegalArgumentException(msg);
                }
            }
            if (key instanceof RSAKey && !algorithmFamily.equals((Object)AlgorithmFamily.RSA)) {
                msg = "Signature algorithm family [" + (Object)((Object)algorithmFamily) + "] is not compatible with the specified RSA key.";
                throw new IllegalArgumentException(msg);
            }
            if (key instanceof ECKey && !algorithmFamily.equals((Object)AlgorithmFamily.EC)) {
                msg = "Signature algorithm family [" + (Object)((Object)algorithmFamily) + "] is not compatible with the specified Elliptic Curve key.";
                throw new IllegalArgumentException(msg);
            }
            Assert.isTrue((boolean)(key instanceof PublicKey), (String)"Specified asymmetric signature verification key is not a PublicKey.  Please ensure you specify a public (not private) key.");
        }
        return key;
    }

    private Resource getResource(JwkConfig jwk) {
        String value;
        if (jwk.isEnabled() && Strings.hasText((String)(value = jwk.getResource()))) {
            try {
                return this.resourceLoader.getResource(value);
            }
            catch (Exception e) {
                String msg = "Unable to load juiser.header.jwt.key.resource [" + value + "].";
                throw new IllegalArgumentException(msg, e);
            }
        }
        return null;
    }

    protected boolean isClassAvailable(String fqcn) {
        return Classes.isAvailable((String)fqcn);
    }

    protected Function<Resource, Key> createResourceKeyFunction(Resource keyResource, boolean keyStringSpecified) {
        if (!this.isClassAvailable("org.bouncycastle.openssl.PEMParser")) {
            String msg = "The org.bouncycastle:bcpkix-jdk15on:1.56 artifact (or newer) must be in the classpath to be able to parse the " + (keyStringSpecified ? "juiser.header.jwt.key.value PEM-encoded value" : "juiser.header.jwt.key.resource [" + keyResource + "].");
            throw new IllegalStateException(msg);
        }
        RuntimeEnvironment.enableBouncyCastleIfPossible();
        return new PemResourceKeyResolver();
    }

    static SignatureAlgorithm getAlgorithm(byte[] hmacSigningKeyBytes) {
        Assert.isTrue((hmacSigningKeyBytes != null && hmacSigningKeyBytes.length > 0 ? 1 : 0) != 0, (String)"hmacSigningBytes cannot be null or empty.");
        if (hmacSigningKeyBytes.length >= 64) {
            return SignatureAlgorithm.HS512;
        }
        if (hmacSigningKeyBytes.length >= 48) {
            return SignatureAlgorithm.HS384;
        }
        return SignatureAlgorithm.HS256;
    }
}

