/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.jwt.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.function.Function;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.juiser.io.Resource;

public class PemResourceKeyResolver
implements Function<Resource, Key> {
    public static final String PEM_PREFIX = "-----BEGIN ";
    private final JcaX509CertificateConverter x509Converter = new JcaX509CertificateConverter().setProvider("BC");
    private final JcaPEMKeyConverter pemKeyConverter = new JcaPEMKeyConverter().setProvider("BC");
    private final boolean findPrivate;

    public PemResourceKeyResolver() {
        this(false);
    }

    public PemResourceKeyResolver(boolean findPrivate) {
        this.findPrivate = findPrivate;
    }

    @Override
    public Key apply(Resource resource) {
        try {
            return this.doApply(resource);
        }
        catch (IOException | CertificateException e) {
            String msg = "Unable to parse resource [" + resource + "]: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }

    private Key doApply(Resource resource) throws IOException, CertificateException {
        Throwable throwable = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream(), "UTF-8"));){
            Object o;
            PEMParser pemParser = new PEMParser((Reader)reader);
            boolean encryptedPrivateFound = false;
            while ((o = pemParser.readObject()) != null) {
                if (o instanceof PKCS8EncryptedPrivateKeyInfo) {
                    encryptedPrivateFound = true;
                }
                if (o instanceof PEMKeyPair) {
                    PEMKeyPair pemKeyPair = (PEMKeyPair)o;
                    Key key = this.findPrivate ? this.pemKeyConverter.getPrivateKey(pemKeyPair.getPrivateKeyInfo()) : this.pemKeyConverter.getPublicKey(pemKeyPair.getPublicKeyInfo());
                    return key;
                }
                if (o instanceof PrivateKeyInfo && this.findPrivate) {
                    PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)o;
                    PrivateKey privateKey = this.pemKeyConverter.getPrivateKey(privateKeyInfo);
                    return privateKey;
                }
                if (o instanceof SubjectPublicKeyInfo && !this.findPrivate) {
                    SubjectPublicKeyInfo info = (SubjectPublicKeyInfo)o;
                    PublicKey publicKey = this.pemKeyConverter.getPublicKey(info);
                    return publicKey;
                }
                if (!(o instanceof X509CertificateHolder) || this.findPrivate) continue;
                X509CertificateHolder holder = (X509CertificateHolder)o;
                X509Certificate cert = this.x509Converter.getCertificate(holder);
                PublicKey publicKey = cert.getPublicKey();
                return publicKey;
            }
            try {
                String msg = encryptedPrivateFound && this.findPrivate ? "Key resource [" + resource + "] contains a PKCS8 Encrypted PrivateKey.  Only unencrypted private keys are supported." : "Key resource [" + resource + "] did not contain a " + (this.findPrivate ? "private " : "public ") + "key.";
                throw new IllegalArgumentException(msg);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

