/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.model;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import org.juiser.model.ImmutablePhone;
import org.juiser.model.User;
import org.juiser.model.UserBuilder;

public class DefaultMapUserFactory
implements Function<Map<String, ?>, User> {
    protected static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC").normalized();

    @Override
    public User apply(Map<String, ?> data) {
        ZonedDateTime zdt;
        Boolean truth;
        UserBuilder builder = new UserBuilder();
        builder.setAuthenticated(true);
        String value = this.getString(data, "href");
        if (value != null) {
            builder.setHref(value);
        }
        if ((value = this.getString(data, "sub")) != null) {
            builder.setId(value);
        }
        StringBuilder fullName = null;
        value = this.getString(data, "name", "full_name", "fullName");
        if (value != null) {
            builder.setName(value);
        } else {
            fullName = new StringBuilder();
        }
        value = this.getString(data, "given_name", "givenName", "first_name", "firstName");
        if (value != null) {
            builder.setGivenName(value);
            this.append(fullName, value);
        }
        if ((value = this.getString(data, "middle_name", "middleName", "middle_names", "middleNames")) != null) {
            builder.setMiddleName(value);
            this.append(fullName, value);
        }
        if ((value = this.getString(data, "family_name", "familyName", "surname")) != null) {
            builder.setFamilyName(value);
            this.append(fullName, value);
        }
        if (fullName != null && fullName.length() > 0) {
            builder.setName(fullName.toString());
        }
        if ((value = this.getString(data, "nickname")) != null) {
            builder.setNickname(value);
        }
        if ((value = this.getString(data, "username", "userName")) != null) {
            builder.setUsername(value);
        }
        if ((value = this.getString(data, "profile")) != null) {
            builder.setProfile(value);
        }
        if ((value = this.getString(data, "picture")) != null) {
            builder.setPicture(value);
        }
        if ((value = this.getString(data, "website")) != null) {
            builder.setWebsite(value);
        }
        if ((value = this.getString(data, "email")) != null) {
            builder.setEmail(value);
        }
        if ((truth = this.getBoolean(data, "email_verified", "emailVerified")) != null) {
            builder.setEmailVerified(truth);
        } else {
            value = this.getString(data, "email_verification_status", "emailVerificationStatus");
            if (value != null) {
                builder.setEmailVerified("verified".equalsIgnoreCase(value));
            }
        }
        value = this.getString(data, "gender", "sex");
        if (value != null) {
            builder.setGender(value);
        }
        if ((value = this.getString(data, "birthdate", "birth_date", "birthDate")) != null) {
            builder.setBirthdate(value);
        }
        if ((value = this.getString(data, "zoneinfo", "zone_info", "zoneInfo", "time_zone", "timezone", "timeZone")) != null) {
            builder.setZoneInfo(value);
        }
        if ((value = this.getString(data, "locale")) != null) {
            builder.setLocale(value);
        }
        boolean verified = false;
        truth = this.getBoolean(data, "phone_number_verified", "phoneNumberVerified", "phone_verified", "phoneVerified");
        if (truth != null) {
            verified = truth;
        } else {
            value = this.getString(data, "phone_number_verification_status", "phoneNumberVerificationStatus", "phone_verification_status", "phoneVerificationStatus");
            if (value != null) {
                verified = "verified".equalsIgnoreCase(value);
            }
        }
        value = this.getString(data, "phone_number", "phoneNumber", "phone");
        if (value != null) {
            builder.setPhone(new ImmutablePhone(value, null, null, verified));
        }
        if ((zdt = DefaultMapUserFactory.getZonedDateTime(data, "created_at", "createdAt")) != null) {
            builder.setCreatedAt(zdt);
        }
        if ((zdt = DefaultMapUserFactory.getZonedDateTime(data, "updated_at", "updatedAt", "modified_at", "modifiedAt")) != null) {
            builder.setUpdatedAt(zdt);
        }
        return builder.build();
    }

    protected static ZonedDateTime getZonedDateTime(Map<String, ?> data, String ... propertyNames) {
        Object obj = DefaultMapUserFactory.getFirst(data, propertyNames);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String && DefaultMapUserFactory.isNumber((String)obj)) {
            obj = Long.parseLong((String)obj);
        }
        if (obj instanceof Number) {
            long seconds = ((Number)obj).longValue();
            return DefaultMapUserFactory.fromEpochSeconds(seconds);
        }
        if (obj instanceof String) {
            return ZonedDateTime.parse((String)obj, DateTimeFormatter.ISO_DATE_TIME);
        }
        throw new IllegalArgumentException("Unrecognized timestamp object: " + obj);
    }

    protected static boolean isNumber(String s) {
        if (s != null) {
            for (char c : s.toCharArray()) {
                if (Character.isDigit(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected static ZonedDateTime fromEpochSeconds(long seconds) {
        long millis = seconds * 1000L;
        Date date = new Date(millis);
        return ZonedDateTime.ofInstant(date.toInstant(), UTC_ZONE_ID);
    }

    private static Object getFirst(Map<String, ?> data, String ... propertyNames) {
        for (String s : propertyNames) {
            Object value = data.get(s);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private String getString(Map<String, ?> data, String ... propertyNames) {
        Object value = DefaultMapUserFactory.getFirst(data, propertyNames);
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }

    private Boolean getBoolean(Map<String, ?> data, String ... propertyNames) {
        for (String s : propertyNames) {
            Object value = data.get(s);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value == null) continue;
            return Boolean.valueOf(String.valueOf(value));
        }
        return null;
    }

    private void append(StringBuilder sb, String value) {
        if (sb == null) {
            return;
        }
        if (sb.length() > 0) {
            sb.append(" ");
        }
        sb.append(value);
    }
}

