/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.model;

import io.jsonwebtoken.lang.Assert;
import org.juiser.model.Phone;

public class ImmutablePhone
implements Phone {
    private final String number;
    private final String digitString;
    private final String name;
    private final String description;
    private final boolean verified;

    public ImmutablePhone(String number, String name, String description, boolean verified) {
        Assert.hasText((String)number, (String)"number argument cannot be null or empty.");
        this.number = number;
        this.digitString = ImmutablePhone.digitsOnly(number);
        this.name = name;
        this.description = description;
        this.verified = verified;
    }

    private static String digitsOnly(String number) {
        StringBuilder sb = new StringBuilder(number.length());
        for (char c : number.toCharArray()) {
            if (c < '0' || c > '9') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getNumber() {
        return this.number;
    }

    @Override
    public boolean isVerified() {
        return this.verified;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImmutablePhone) {
            ImmutablePhone phone = (ImmutablePhone)obj;
            return this.digitString.equals(phone.digitString);
        }
        return false;
    }

    public int hashCode() {
        return this.digitString.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.name).append(": ");
        }
        sb.append(this.number).append(" (").append(this.verified ? "verified" : "unverified");
        if (this.description != null) {
            sb.append(", ").append(this.description);
        }
        sb.append(")");
        return sb.toString();
    }
}

