/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.model;

import java.net.URL;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.TimeZone;
import org.juiser.model.Phone;
import org.juiser.model.User;

public class ImmutableUser
implements User {
    private final boolean authenticated;
    private final String href;
    private final String id;
    private final String name;
    private final String givenName;
    private final String familyName;
    private final String middleName;
    private final String nickname;
    private final String username;
    private final URL profile;
    private final URL picture;
    private final URL website;
    private final String email;
    private final boolean emailVerified;
    private final String gender;
    private final LocalDate birthdate;
    private final TimeZone zoneInfo;
    private final Locale locale;
    private final Phone phone;
    private final ZonedDateTime createdAt;
    private final ZonedDateTime updatedAt;

    public ImmutableUser(boolean authenticated, String href, String id, String name, String givenName, String familyName, String middleName, String nickname, String username, URL profile, URL picture, URL website, String email, boolean emailVerified, String gender, LocalDate birthdate, TimeZone zoneInfo, Locale locale, Phone phone, ZonedDateTime createdAt, ZonedDateTime updatedAt) {
        this.authenticated = authenticated;
        this.href = href;
        this.id = id;
        this.name = name;
        this.givenName = givenName;
        this.familyName = familyName;
        this.middleName = middleName;
        this.nickname = nickname;
        this.username = username;
        this.profile = profile;
        this.picture = picture;
        this.website = website;
        this.email = email;
        this.emailVerified = emailVerified;
        this.gender = gender;
        this.birthdate = birthdate;
        this.zoneInfo = zoneInfo;
        this.locale = locale;
        this.phone = phone;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public boolean isAnonymous() {
        return !this.authenticated;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getGivenName() {
        return this.givenName;
    }

    @Override
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    public String getMiddleName() {
        return this.middleName;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public URL getProfile() {
        return this.profile;
    }

    @Override
    public URL getPicture() {
        return this.picture;
    }

    @Override
    public URL getWebsite() {
        return this.website;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    @Override
    public String getGender() {
        return this.gender;
    }

    @Override
    public LocalDate getBirthdate() {
        return this.birthdate;
    }

    @Override
    public TimeZone getZoneInfo() {
        return this.zoneInfo;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public Phone getPhone() {
        return this.phone;
    }

    @Override
    public String getPhoneNumber() {
        return this.phone != null ? this.phone.getNumber() : null;
    }

    @Override
    public boolean isPhoneNumberVerified() {
        return this.phone != null && this.phone.isVerified();
    }

    @Override
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ImmutableUser)) {
            return false;
        }
        ImmutableUser that = (ImmutableUser)o;
        if (this.authenticated != that.authenticated) {
            return false;
        }
        if (this.emailVerified != that.emailVerified) {
            return false;
        }
        if (this.href != null ? !this.href.equals(that.href) : that.href != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.givenName != null ? !this.givenName.equals(that.givenName) : that.givenName != null) {
            return false;
        }
        if (this.familyName != null ? !this.familyName.equals(that.familyName) : that.familyName != null) {
            return false;
        }
        if (this.middleName != null ? !this.middleName.equals(that.middleName) : that.middleName != null) {
            return false;
        }
        if (this.nickname != null ? !this.nickname.equals(that.nickname) : that.nickname != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.profile != null ? !this.profile.equals(that.profile) : that.profile != null) {
            return false;
        }
        if (this.picture != null ? !this.picture.equals(that.picture) : that.picture != null) {
            return false;
        }
        if (this.website != null ? !this.website.equals(that.website) : that.website != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (this.gender != null ? !this.gender.equals(that.gender) : that.gender != null) {
            return false;
        }
        if (this.birthdate != null ? !this.birthdate.equals(that.birthdate) : that.birthdate != null) {
            return false;
        }
        if (this.zoneInfo != null ? !this.zoneInfo.equals(that.zoneInfo) : that.zoneInfo != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
            return false;
        }
        if (this.phone != null ? !this.phone.equals(that.phone) : that.phone != null) {
            return false;
        }
        if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) {
            return false;
        }
        return this.updatedAt != null ? this.updatedAt.equals(that.updatedAt) : that.updatedAt == null;
    }

    public int hashCode() {
        int result = this.authenticated ? 1 : 0;
        result = 31 * result + (this.href != null ? this.href.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.givenName != null ? this.givenName.hashCode() : 0);
        result = 31 * result + (this.familyName != null ? this.familyName.hashCode() : 0);
        result = 31 * result + (this.middleName != null ? this.middleName.hashCode() : 0);
        result = 31 * result + (this.nickname != null ? this.nickname.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.profile != null ? this.profile.hashCode() : 0);
        result = 31 * result + (this.picture != null ? this.picture.hashCode() : 0);
        result = 31 * result + (this.website != null ? this.website.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.emailVerified ? 1 : 0);
        result = 31 * result + (this.gender != null ? this.gender.hashCode() : 0);
        result = 31 * result + (this.birthdate != null ? this.birthdate.hashCode() : 0);
        result = 31 * result + (this.zoneInfo != null ? this.zoneInfo.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (this.phone != null ? this.phone.hashCode() : 0);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + (this.updatedAt != null ? this.updatedAt.hashCode() : 0);
        return result;
    }
}

