/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.model;

import java.net.URL;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.TimeZone;
import org.juiser.model.Phone;
import org.juiser.model.User;

public abstract class ResolvingUser
implements User {
    protected abstract User findUser();

    private User getRequiredUser() {
        User user = this.findUser();
        if (user == null) {
            String msg = "Unable to acquire required " + User.class.getName() + " instance from the current " + this.getClass().getName() + " runtime context.";
            throw new IllegalStateException(msg);
        }
        return user;
    }

    @Override
    public boolean isAuthenticated() {
        return this.findUser() != null;
    }

    @Override
    public boolean isAnonymous() {
        return !this.isAuthenticated();
    }

    @Override
    public String getHref() {
        return this.isAnonymous() ? null : this.getRequiredUser().getHref();
    }

    @Override
    public String getId() {
        return this.isAnonymous() ? null : this.getRequiredUser().getId();
    }

    @Override
    public String getName() {
        return this.isAnonymous() ? null : this.getRequiredUser().getName();
    }

    @Override
    public String getGivenName() {
        return this.isAnonymous() ? null : this.getRequiredUser().getGivenName();
    }

    @Override
    public String getFamilyName() {
        return this.isAnonymous() ? null : this.getRequiredUser().getFamilyName();
    }

    @Override
    public String getMiddleName() {
        return this.isAnonymous() ? null : this.getRequiredUser().getMiddleName();
    }

    @Override
    public String getNickname() {
        return this.isAnonymous() ? null : this.getRequiredUser().getNickname();
    }

    @Override
    public String getUsername() {
        return this.isAnonymous() ? null : this.getRequiredUser().getUsername();
    }

    @Override
    public URL getProfile() {
        return this.isAnonymous() ? null : this.getRequiredUser().getProfile();
    }

    @Override
    public URL getPicture() {
        return this.isAnonymous() ? null : this.getRequiredUser().getPicture();
    }

    @Override
    public URL getWebsite() {
        return this.isAnonymous() ? null : this.getRequiredUser().getWebsite();
    }

    @Override
    public String getEmail() {
        return this.isAnonymous() ? null : this.getRequiredUser().getEmail();
    }

    @Override
    public boolean isEmailVerified() {
        return this.isAuthenticated() && this.getRequiredUser().isEmailVerified();
    }

    @Override
    public String getGender() {
        return this.isAnonymous() ? null : this.getRequiredUser().getGender();
    }

    @Override
    public LocalDate getBirthdate() {
        return this.isAnonymous() ? null : this.getRequiredUser().getBirthdate();
    }

    @Override
    public TimeZone getZoneInfo() {
        return this.isAnonymous() ? null : this.getRequiredUser().getZoneInfo();
    }

    @Override
    public Locale getLocale() {
        return this.isAnonymous() ? null : this.getRequiredUser().getLocale();
    }

    @Override
    public Phone getPhone() {
        return this.isAnonymous() ? null : this.getRequiredUser().getPhone();
    }

    @Override
    public String getPhoneNumber() {
        return this.isAnonymous() ? null : this.getRequiredUser().getPhoneNumber();
    }

    @Override
    public boolean isPhoneNumberVerified() {
        return this.isAuthenticated() && this.getRequiredUser().isPhoneNumberVerified();
    }

    @Override
    public ZonedDateTime getCreatedAt() {
        return this.isAnonymous() ? null : this.getRequiredUser().getCreatedAt();
    }

    @Override
    public ZonedDateTime getUpdatedAt() {
        return this.isAnonymous() ? null : this.getRequiredUser().getUpdatedAt();
    }
}

