/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.TimeZone;
import org.juiser.model.ImmutableUser;
import org.juiser.model.Phone;
import org.juiser.model.User;

public class UserBuilder {
    private boolean authenticated;
    private String href;
    private String id;
    private String name;
    private String givenName;
    private String middleName;
    private String familyName;
    private String nickname;
    private String username;
    private URL profile;
    private URL picture;
    private URL website;
    private String email;
    private boolean emailVerified;
    private String gender;
    private LocalDate birthdate;
    private TimeZone zoneInfo;
    private Locale locale;
    private Phone phone;
    private ZonedDateTime createdAt;
    private ZonedDateTime updatedAt;

    public UserBuilder setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
        return this;
    }

    public UserBuilder setHref(String href) {
        this.href = href;
        return this;
    }

    public UserBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public UserBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public UserBuilder setGivenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    public UserBuilder setMiddleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    public UserBuilder setFamilyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    public UserBuilder setNickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    public UserBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public UserBuilder setProfile(String profile) {
        this.setProfile(this.toUrl(profile, "profile"));
        return this;
    }

    private URL toUrl(String url, String propertyName) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            String msg = "Invalid " + propertyName + " URL: " + this.profile;
            throw new IllegalArgumentException(msg);
        }
    }

    public UserBuilder setProfile(URL profile) {
        this.profile = profile;
        return this;
    }

    public UserBuilder setPicture(String picture) {
        this.setPicture(this.toUrl(picture, "picture"));
        return this;
    }

    public UserBuilder setPicture(URL picture) {
        this.picture = picture;
        return this;
    }

    public UserBuilder setWebsite(String website) {
        this.setWebsite(this.toUrl(website, "website"));
        return this;
    }

    public UserBuilder setWebsite(URL website) {
        this.website = website;
        return this;
    }

    public UserBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public UserBuilder setEmailVerified(boolean emailVerified) {
        this.emailVerified = emailVerified;
        return this;
    }

    public UserBuilder setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public UserBuilder setBirthdate(String iso8601) {
        LocalDate date = LocalDate.parse(iso8601, DateTimeFormatter.ISO_LOCAL_DATE);
        this.setBirthdate(date);
        return this;
    }

    public UserBuilder setBirthdate(LocalDate birthdate) {
        this.birthdate = birthdate;
        return this;
    }

    public UserBuilder setZoneInfo(String info) {
        this.setZoneInfo(TimeZone.getTimeZone(info));
        return this;
    }

    public UserBuilder setZoneInfo(TimeZone zoneInfo) {
        this.zoneInfo = zoneInfo;
        return this;
    }

    public UserBuilder setLocale(String locale) {
        this.setLocale(Locale.forLanguageTag(locale));
        return this;
    }

    public UserBuilder setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public UserBuilder setPhone(Phone phone) {
        this.phone = phone;
        return this;
    }

    public UserBuilder setCreatedAt(ZonedDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public UserBuilder setUpdatedAt(ZonedDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public User build() {
        return new ImmutableUser(this.authenticated, this.href, this.id, this.name, this.givenName, this.familyName, this.middleName, this.nickname, this.username, this.profile, this.picture, this.website, this.email, this.emailVerified, this.gender, this.birthdate, this.zoneInfo, this.locale, this.phone, this.createdAt, this.updatedAt);
    }
}

