/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.spring.security.authentication;

import io.jsonwebtoken.JwtException;
import java.util.function.Function;
import org.juiser.spring.security.authentication.HeaderAuthenticationToken;
import org.juiser.spring.security.core.ForwardedUserAuthentication;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HeaderAuthenticationProvider
implements AuthenticationProvider {
    private final Function<String, UserDetails> converter;

    public HeaderAuthenticationProvider(Function<String, UserDetails> converter) {
        Assert.notNull(converter, (String)"converter function cannot be null.");
        this.converter = converter;
    }

    public boolean supports(Class<?> authentication) {
        return HeaderAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UserDetails details;
        HeaderAuthenticationToken token = (HeaderAuthenticationToken)authentication;
        Object creds = token.getCredentials();
        if (!(creds instanceof String)) {
            throw new BadCredentialsException("HeaderAuthenticationToken credentials must be a String.");
        }
        String value = (String)creds;
        if (!StringUtils.hasText((String)value)) {
            throw new BadCredentialsException("HeaderAuthenticationToken credentials String cannot be null or empty.");
        }
        try {
            details = this.converter.apply(value);
        }
        catch (JwtException e) {
            String msg = "Invalid or unsupported request header JWT: " + e.getMessage();
            throw new BadCredentialsException(msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Unexpected exception during authentication header parsing: " + e.getMessage();
            throw new InternalAuthenticationServiceException(msg, (Throwable)e);
        }
        return new ForwardedUserAuthentication(details);
    }
}

