/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.spring.security.authentication;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.lang.Assert;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.juiser.model.User;
import org.juiser.spring.security.core.userdetails.ForwardedUserDetails;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class JwsToUserDetailsConverter
implements Function<String, UserDetails> {
    private final Function<String, Claims> claimsExtractor;
    private final Function<Claims, User> claimsUserFactory;
    private final Function<Claims, Collection<? extends GrantedAuthority>> authoritiesResolver;

    public JwsToUserDetailsConverter(Function<String, Claims> claimsExtractor, Function<Claims, User> claimsUserFactory, Function<Claims, Collection<? extends GrantedAuthority>> authoritiesResolver) {
        Assert.notNull(claimsExtractor, (String)"claimsExtractor cannot be null.");
        Assert.notNull(claimsUserFactory, (String)"claimsUserFactory cannot be null.");
        this.claimsExtractor = claimsExtractor;
        this.claimsUserFactory = claimsUserFactory;
        this.authoritiesResolver = authoritiesResolver;
    }

    @Override
    public UserDetails apply(String headerValue) {
        Claims claims = this.claimsExtractor.apply(headerValue);
        User user = this.claimsUserFactory.apply(claims);
        Collection<Object> authorities = Collections.emptyList();
        if (this.authoritiesResolver != null) {
            authorities = this.authoritiesResolver.apply(claims);
        }
        return new ForwardedUserDetails(user, authorities);
    }
}

