/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.spring.security.core.userdetails;

import java.util.Collection;
import java.util.Collections;
import org.juiser.model.User;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ForwardedUserDetails
implements UserDetails {
    private final User user;
    private final Collection<? extends GrantedAuthority> grantedAuthorities;

    public ForwardedUserDetails(User user, Collection<? extends GrantedAuthority> grantedAuthorities) {
        Assert.notNull((Object)user, (String)"User argument cannot be null.");
        Assert.hasText((String)user.getUsername(), (String)"User username cannot be null or empty.");
        this.user = user;
        this.grantedAuthorities = CollectionUtils.isEmpty(grantedAuthorities) ? Collections.emptyList() : Collections.unmodifiableCollection(grantedAuthorities);
    }

    public User getUser() {
        return this.user;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.grantedAuthorities;
    }

    public String getPassword() {
        return null;
    }

    public String getUsername() {
        return this.getUser().getUsername();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }
}

