/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.spring.security.user;

import org.juiser.model.ResolvingUser;
import org.juiser.model.User;
import org.juiser.spring.security.core.userdetails.ForwardedUserDetails;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class SecurityContextUser
extends ResolvingUser {
    protected SecurityContext getSecurityContext() {
        return SecurityContextHolder.getContext();
    }

    protected Authentication getValidAuthentication() {
        Authentication authc;
        SecurityContext ctx = this.getSecurityContext();
        if (ctx != null && (authc = ctx.getAuthentication()) != null && !(authc instanceof AnonymousAuthenticationToken) && authc.isAuthenticated()) {
            return authc;
        }
        return null;
    }

    public boolean isAuthenticated() {
        return this.getValidAuthentication() != null;
    }

    protected User findUser() {
        Authentication authc = this.getValidAuthentication();
        Assert.notNull((Object)authc, (String)"Current SecurityContext Authentication cannot be null.");
        Object value = authc.getPrincipal();
        Assert.isInstanceOf(ForwardedUserDetails.class, (Object)value, (String)"securityContext.getAuthentication().getPrincipal() must contain a ForwardedUserDetails instance.");
        User user = null;
        if (value instanceof ForwardedUserDetails) {
            ForwardedUserDetails details = (ForwardedUserDetails)value;
            user = details.getUser();
        }
        if (user != null) {
            return user;
        }
        String msg = "Unable to acquire required " + User.class.getName() + " instance from the current SecurityContext Authentication.";
        throw new IllegalStateException(msg);
    }
}

