/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.spring.security.web.authentication;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.juiser.spring.security.authentication.HeaderAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class HeaderAuthenticationFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(HeaderAuthenticationFilter.class);
    private final String headerName;
    private final AuthenticationManager authenticationManager;
    private final RequestMatcher requiresAuthenticationRequestMatcher;

    public HeaderAuthenticationFilter(String headerName, AuthenticationManager authenticationManager) {
        Assert.hasText((String)headerName, (String)"headerName cannot be null or empty.");
        Assert.notNull((Object)"AuthenticationManager is required.");
        this.headerName = headerName;
        this.requiresAuthenticationRequestMatcher = new RequestHeaderRequestMatcher(headerName, null);
        this.authenticationManager = authenticationManager;
    }

    protected String getHeaderName() {
        return this.headerName;
    }

    protected AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    protected RequestMatcher getRequiresAuthenticationRequestMatcher() {
        return this.requiresAuthenticationRequestMatcher;
    }

    public void afterPropertiesSet() throws ServletException {
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager must be specified");
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return this.getRequiresAuthenticationRequestMatcher().matches(request);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (!this.requiresAuthentication(request, response)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        log.debug("Request will be authenticated.");
        boolean continueChain = true;
        Authentication authResult = null;
        try {
            authResult = this.attemptAuthentication(request, response);
            Assert.notNull((Object)authResult, (String)"authResult cannot be null.");
        }
        catch (InternalAuthenticationServiceException failed) {
            log.error("An internal error occurred while trying to authenticate the request header. Request will be anonymous.", (Throwable)failed);
            continueChain = this.unsuccessfulAuthentication(request, response, chain, (AuthenticationException)((Object)failed));
        }
        catch (AuthenticationException failed) {
            continueChain = this.unsuccessfulAuthentication(request, response, chain, failed);
        }
        if (authResult != null) {
            continueChain = this.successfulAuthentication(request, response, chain, authResult);
        }
        if (continueChain) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected boolean successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        log.debug("Request authenticated.  Updating SecurityContextHolder to contain: {}", (Object)authResult);
        SecurityContextHolder.getContext().setAuthentication(authResult);
        return true;
    }

    protected boolean unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, AuthenticationException failed) throws IOException, ServletException {
        SecurityContextHolder.clearContext();
        if (log.isDebugEnabled()) {
            log.debug("Authentication request failed: " + failed.toString(), (Throwable)failed);
            log.debug("Updated SecurityContextHolder to contain null Authentication");
            log.debug("Continuing filter chain with null Authentication");
        }
        return true;
    }

    protected Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        String name = this.getHeaderName();
        String value = request.getHeader(name);
        Assert.hasText((String)value, (String)"Missing expected request header value.");
        HeaderAuthenticationToken token = new HeaderAuthenticationToken(name, value);
        return this.getAuthenticationManager().authenticate((Authentication)token);
    }
}

