/*
 * Decompiled with CFR 0.152.
 */
package org.juiser.spring.jwt;

import io.jsonwebtoken.Claims;
import java.util.function.Function;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class ClaimsExpressionEvaluator
implements Function<Claims, Object> {
    private final String expressionString;
    private final Expression expression;

    public ClaimsExpressionEvaluator(String spelExpression) {
        Assert.hasText((String)spelExpression, (String)"spelExpression argument cannot be null or empty.");
        SpelExpressionParser parser = new SpelExpressionParser();
        this.expressionString = spelExpression;
        this.expression = parser.parseExpression(spelExpression);
    }

    @Override
    public Object apply(Claims claims) {
        return this.expression.getValue((Object)claims);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.expressionString + "]";
    }
}

