/*
 * Decompiled with CFR 0.152.
 */
package spacro.tasks;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.ConnectionContext;
import akka.http.scaladsl.ConnectionContext$;
import akka.http.scaladsl.Http;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.server.ExceptionHandler;
import akka.http.scaladsl.server.RejectionHandler;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.RouteResult$;
import akka.http.scaladsl.server.RoutingLog;
import akka.http.scaladsl.server.RoutingLog$;
import akka.http.scaladsl.settings.ParserSettings;
import akka.http.scaladsl.settings.ParserSettings$;
import akka.http.scaladsl.settings.RoutingSettings;
import akka.http.scaladsl.settings.RoutingSettings$;
import akka.http.scaladsl.settings.ServerSettings;
import akka.stream.ActorMaterializer$;
import akka.stream.Materializer;
import akka.stream.scaladsl.Flow;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Scanner;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import spacro.tasks.TaskConfig;
import spacro.tasks.TaskSpecification;
import spacro.tasks.Webservice;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u000f\t11+\u001a:wKJT!a\u0001\u0003\u0002\u000bQ\f7o[:\u000b\u0003\u0015\taa\u001d9bGJ|7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010-5\t\u0001C\u0003\u0002\u0012%\u0005a1oY1mC2|wmZ5oO*\u00111\u0003F\u0001\tif\u0004Xm]1gK*\tQ#A\u0002d_6L!a\u0006\t\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0011!\u0019\u0001A!A!\u0002\u0013I\u0002c\u0001\u000e#K9\u00111\u0004\t\b\u00039}i\u0011!\b\u0006\u0003=\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005\u0005R\u0011a\u00029bG.\fw-Z\u0005\u0003G\u0011\u0012A\u0001T5ti*\u0011\u0011E\u0003\t\u0003M\u001dj\u0011AA\u0005\u0003Q\t\u0011\u0011\u0003V1tWN\u0003XmY5gS\u000e\fG/[8o\u0011!Q\u0003A!A!\u0002\u0017Y\u0013AB2p]\u001aLw\r\u0005\u0002'Y%\u0011QF\u0001\u0002\u000b)\u0006\u001c8nQ8oM&<\u0007\"B\u0018\u0001\t\u0003\u0001\u0014A\u0002\u001fj]&$h\b\u0006\u00022iQ\u0011!g\r\t\u0003M\u0001AQA\u000b\u0018A\u0004-BQa\u0001\u0018A\u0002eAqA\u000e\u0001C\u0002\u0013\rq'\u0001\u0004tsN$X-\\\u000b\u0002qA\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0006C\u000e$xN\u001d\u0006\u0002{\u0005!\u0011m[6b\u0013\ty$HA\u0006BGR|'oU=ti\u0016l\u0007BB!\u0001A\u0003%\u0001(A\u0004tsN$X-\u001c\u0011\t\u000f\r\u0003!\u0019!C\u0002\t\u0006aQ.\u0019;fe&\fG.\u001b>feV\tQ\t\u0005\u0002G\u00136\tqI\u0003\u0002Iy\u000511\u000f\u001e:fC6L!AS$\u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\t\r1\u0003\u0001\u0015!\u0003F\u00035i\u0017\r^3sS\u0006d\u0017N_3sA!9a\n\u0001b\u0001\n\u0003y\u0015aB:feZL7-Z\u000b\u0002!B\u0011a%U\u0005\u0003%\n\u0011!bV3cg\u0016\u0014h/[2f\u0011\u0019!\u0006\u0001)A\u0005!\u0006A1/\u001a:wS\u000e,\u0007\u0005C\u0004W\u0001\t\u0007I\u0011A,\u0002\u0017!$H\u000f\u001d\"j]\u0012LgnZ\u000b\u00021B\u0019\u0011\f\u00180\u000e\u0003iS!a\u0017\u0006\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002^5\n1a)\u001e;ve\u0016\u0004\"aX4\u000f\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001C:dC2\fGm\u001d7\u000b\u0005\u0011d\u0014\u0001\u00025uiBL!AZ1\u0002\t!#H\u000f]\u0005\u0003Q&\u0014QbU3sm\u0016\u0014()\u001b8eS:<'B\u00014b\u0011\u0019Y\u0007\u0001)A\u00051\u0006a\u0001\u000e\u001e;q\u0005&tG-\u001b8hA!9Q\u000e\u0001b\u0001\n\u0003q\u0017a\u00035uiB\u001c8+\u001a:wKJ,\u0012a\u001c\t\u0004aN,X\"A9\u000b\u0005IT\u0011\u0001B;uS2L!\u0001^9\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002\nm&\u0011qO\u0003\u0002\u0005+:LG\u000f\u0003\u0004z\u0001\u0001\u0006Ia\\\u0001\rQR$\bo]*feZ,'\u000f\t")
public class Server
implements StrictLogging {
    private final TaskConfig config;
    private final ActorSystem system;
    private final Materializer materializer;
    private final Webservice service;
    private final Future<Http.ServerBinding> httpBinding;
    private final Try<BoxedUnit> httpsServer;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ActorSystem system() {
        return this.system;
    }

    public Materializer materializer() {
        return this.materializer;
    }

    public Webservice service() {
        return this.service;
    }

    public Future<Http.ServerBinding> httpBinding() {
        return this.httpBinding;
    }

    public Try<BoxedUnit> httpsServer() {
        return this.httpsServer;
    }

    public static final /* synthetic */ void $anonfun$new$1(Server $this, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            Success success = (Success)try_;
            Http.ServerBinding binding = (Http.ServerBinding)success.value();
            InetSocketAddress localAddress = binding.localAddress();
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(31).append("Server is listening on http://").append(localAddress.getHostName()).append(":").append(localAddress.getPort()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error(new StringBuilder(21).append("HTTP binding failed: ").append(e).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$httpsServer$3(Server $this, Try x0$2) {
        Try try_ = x0$2;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            Success success = (Success)try_;
            Http.ServerBinding binding = (Http.ServerBinding)success.value();
            InetSocketAddress localAddress = binding.localAddress();
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(32).append("Server is listening on https://").append(localAddress.getHostName()).append(":").append(localAddress.getPort()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if ($this.logger().underlying().isWarnEnabled()) {
                $this.logger().underlying().warn(new StringBuilder(22).append("HTTPS binding failed: ").append(e).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public Server(List<TaskSpecification> tasks, TaskConfig config) {
        this.config = config;
        StrictLogging.$init$((StrictLogging)this);
        this.system = config.actorSystem();
        this.materializer = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)this.system());
        this.service = new Webservice(tasks, this.materializer(), config);
        HttpExt qual$1 = Http$.MODULE$.apply(this.system());
        Function1<RequestContext, Future<RouteResult>> x$1 = this.service().route();
        RoutingSettings x$2 = (RoutingSettings)RoutingSettings$.MODULE$.default((ActorRefFactory)this.system());
        ParserSettings x$3 = (ParserSettings)ParserSettings$.MODULE$.default((ActorRefFactory)this.system());
        Materializer x$4 = this.materializer();
        RoutingLog x$5 = RoutingLog$.MODULE$.fromActorSystem(this.system());
        ExecutionContextExecutor x$6 = this.system().dispatcher();
        RejectionHandler x$7 = RouteResult$.MODULE$.route2HandlerFlow$default$7(x$1);
        ExceptionHandler x$8 = RouteResult$.MODULE$.route2HandlerFlow$default$8(x$1);
        Flow x$9 = RouteResult$.MODULE$.route2HandlerFlow(x$1, x$2, x$3, x$4, x$5, (ExecutionContext)x$6, x$7, x$8);
        String x$10 = config.interface();
        int x$11 = config.httpPort();
        ConnectionContext x$12 = qual$1.bindAndHandle$default$4();
        ServerSettings x$13 = qual$1.bindAndHandle$default$5();
        LoggingAdapter x$14 = qual$1.bindAndHandle$default$6();
        this.httpBinding = qual$1.bindAndHandle(x$9, x$10, x$11, x$12, x$13, x$14, this.materializer());
        this.httpBinding().onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Server.$anonfun$new$1(this, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.system().dispatcher());
        this.httpsServer = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            char[] password = new Scanner(this.getClass().getClassLoader().getResourceAsStream(new StringBuilder(18).append($this.config.serverDomain()).append("-keystore-password").toString())).next().toCharArray();
            KeyStore ks = KeyStore.getInstance("PKCS12");
            InputStream keystore = this.getClass().getClassLoader().getResourceAsStream(new StringBuilder(4).append($this.config.serverDomain()).append(".p12").toString());
            Predef$.MODULE$.require(keystore != null, (Function0 & Serializable & scala.Serializable)() -> "Keystore required!");
            ks.load(keystore, password);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(ks, password);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(keyManagerFactory.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
            HttpsConnectionContext https = ConnectionContext$.MODULE$.https(sslContext, ConnectionContext$.MODULE$.https$default$2(), ConnectionContext$.MODULE$.https$default$3(), ConnectionContext$.MODULE$.https$default$4(), ConnectionContext$.MODULE$.https$default$5(), ConnectionContext$.MODULE$.https$default$6());
            HttpExt qual$2 = Http$.MODULE$.apply(this.system());
            Function1<RequestContext, Future<RouteResult>> x$15 = this.service().route();
            RoutingSettings x$16 = (RoutingSettings)RoutingSettings$.MODULE$.default((ActorRefFactory)this.system());
            ParserSettings x$17 = (ParserSettings)ParserSettings$.MODULE$.default((ActorRefFactory)this.system());
            Materializer x$18 = this.materializer();
            RoutingLog x$19 = RoutingLog$.MODULE$.fromActorSystem(this.system());
            ExecutionContextExecutor x$20 = this.system().dispatcher();
            RejectionHandler x$21 = RouteResult$.MODULE$.route2HandlerFlow$default$7(x$15);
            ExceptionHandler x$22 = RouteResult$.MODULE$.route2HandlerFlow$default$8(x$15);
            Flow x$23 = RouteResult$.MODULE$.route2HandlerFlow(x$15, x$16, x$17, x$18, x$19, (ExecutionContext)x$20, x$21, x$22);
            String x$24 = $this.config.interface();
            int x$25 = $this.config.httpsPort();
            HttpsConnectionContext x$26 = https;
            ServerSettings x$27 = qual$2.bindAndHandle$default$5();
            LoggingAdapter x$28 = qual$2.bindAndHandle$default$6();
            Future httpsBinding = qual$2.bindAndHandle(x$23, x$24, x$25, (ConnectionContext)x$26, x$27, x$28, this.materializer());
            httpsBinding.onComplete((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Server.$anonfun$httpsServer$3(this, x0$2);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.system().dispatcher());
        });
        Try<BoxedUnit> try_ = this.httpsServer();
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(28).append("HTTPS configuration failed: ").append(e).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError(try_);
        }
    }
}

