/*
 * Decompiled with CFR 0.152.
 */
package spacro.tasks;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.ConnectionContext;
import akka.http.scaladsl.ConnectionContext$;
import akka.http.scaladsl.Http;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.server.ExceptionHandler;
import akka.http.scaladsl.server.RejectionHandler;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.RouteResult$;
import akka.http.scaladsl.server.RoutingLog;
import akka.http.scaladsl.server.RoutingLog$;
import akka.http.scaladsl.settings.ParserSettings;
import akka.http.scaladsl.settings.ParserSettings$;
import akka.http.scaladsl.settings.RoutingSettings;
import akka.http.scaladsl.settings.RoutingSettings$;
import akka.http.scaladsl.settings.ServerSettings;
import akka.stream.ActorMaterializer$;
import akka.stream.Materializer;
import akka.stream.scaladsl.Flow;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Scanner;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import spacro.tasks.TaskConfig;
import spacro.tasks.TaskSpecification;
import spacro.tasks.Webservice;

@ScalaSignature(bytes="\u0006\u0001i4AAD\b\u0001)!A\u0001\u0003\u0001B\u0001B\u0003%Q\u0005\u0003\u00056\u0001\t\u0005\t\u0015a\u00037\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u001dy\u0004A1A\u0005\u0004\u0001Ca!\u0013\u0001!\u0002\u0013\t\u0005b\u0002&\u0001\u0005\u0004%\u0019a\u0013\u0005\u0007%\u0002\u0001\u000b\u0011\u0002'\t\u000fM\u0003!\u0019!C\u0001)\"1\u0001\f\u0001Q\u0001\nUCq!\u0017\u0001C\u0002\u0013\u0005!\f\u0003\u0004n\u0001\u0001\u0006Ia\u0017\u0005\b]\u0002\u0011\r\u0011\"\u0001p\u0011\u0019I\b\u0001)A\u0005a\n11+\u001a:wKJT!\u0001E\t\u0002\u000bQ\f7o[:\u000b\u0003I\taa\u001d9bGJ|7\u0001A\n\u0004\u0001UY\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u001dG5\tQD\u0003\u0002\u001f?\u0005a1oY1mC2|wmZ5oO*\u0011\u0001%I\u0001\tif\u0004Xm]1gK*\t!%A\u0002d_6L!\u0001J\u000f\u0003\u001bM#(/[2u\u0019><w-\u001b8h!\r1c&\r\b\u0003O1r!\u0001K\u0016\u000e\u0003%R!AK\n\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0012BA\u0017\u0018\u0003\u001d\u0001\u0018mY6bO\u0016L!a\f\u0019\u0003\t1K7\u000f\u001e\u0006\u0003[]\u0001\"AM\u001a\u000e\u0003=I!\u0001N\b\u0003#Q\u000b7o[*qK\u000eLg-[2bi&|g.\u0001\u0004d_:4\u0017n\u001a\t\u0003e]J!\u0001O\b\u0003\u0015Q\u000b7o[\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u0003wy\"\"\u0001P\u001f\u0011\u0005I\u0002\u0001\"B\u001b\u0004\u0001\b1\u0004\"\u0002\t\u0004\u0001\u0004)\u0013AB:zgR,W.F\u0001B!\t\u0011u)D\u0001D\u0015\t!U)A\u0003bGR|'OC\u0001G\u0003\u0011\t7n[1\n\u0005!\u001b%aC!di>\u00148+_:uK6\fqa]=ti\u0016l\u0007%\u0001\u0007nCR,'/[1mSj,'/F\u0001M!\ti\u0005+D\u0001O\u0015\tyU)\u0001\u0004tiJ,\u0017-\\\u0005\u0003#:\u0013A\"T1uKJL\u0017\r\\5{KJ\fQ\"\\1uKJL\u0017\r\\5{KJ\u0004\u0013aB:feZL7-Z\u000b\u0002+B\u0011!GV\u0005\u0003/>\u0011!bV3cg\u0016\u0014h/[2f\u0003!\u0019XM\u001d<jG\u0016\u0004\u0013a\u00035uiB\u0014\u0015N\u001c3j]\u001e,\u0012a\u0017\t\u00049~\u000bW\"A/\u000b\u0005y;\u0012AC2p]\u000e,(O]3oi&\u0011\u0001-\u0018\u0002\u0007\rV$XO]3\u0011\u0005\tTgBA2i\u001b\u0005!'BA3g\u0003!\u00198-\u00197bINd'BA4F\u0003\u0011AG\u000f\u001e9\n\u0005%$\u0017\u0001\u0002%uiBL!a\u001b7\u0003\u001bM+'O^3s\u0005&tG-\u001b8h\u0015\tIG-\u0001\u0007iiR\u0004()\u001b8eS:<\u0007%A\u0006iiR\u00048oU3sm\u0016\u0014X#\u00019\u0011\u0007E$h/D\u0001s\u0015\t\u0019x#\u0001\u0003vi&d\u0017BA;s\u0005\r!&/\u001f\t\u0003-]L!\u0001_\f\u0003\tUs\u0017\u000e^\u0001\rQR$\bo]*feZ,'\u000f\t")
public class Server
implements StrictLogging {
    private final TaskConfig config;
    private final ActorSystem system;
    private final Materializer materializer;
    private final Webservice service;
    private final Future<Http.ServerBinding> httpBinding;
    private final Try<BoxedUnit> httpsServer;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ActorSystem system() {
        return this.system;
    }

    public Materializer materializer() {
        return this.materializer;
    }

    public Webservice service() {
        return this.service;
    }

    public Future<Http.ServerBinding> httpBinding() {
        return this.httpBinding;
    }

    public Try<BoxedUnit> httpsServer() {
        return this.httpsServer;
    }

    public static final /* synthetic */ void $anonfun$new$1(Server $this, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            Success success = (Success)try_;
            Http.ServerBinding binding = (Http.ServerBinding)success.value();
            InetSocketAddress localAddress = binding.localAddress();
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Server is listening on http://{}:{}", new Object[]{localAddress.getHostName(), BoxesRunTime.boxToInteger((int)localAddress.getPort())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("HTTP binding failed: {}", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$httpsServer$3(Server $this, Try x0$2) {
        Try try_ = x0$2;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            Success success = (Success)try_;
            Http.ServerBinding binding = (Http.ServerBinding)success.value();
            InetSocketAddress localAddress = binding.localAddress();
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Server is listening on https://{}:{}", new Object[]{localAddress.getHostName(), BoxesRunTime.boxToInteger((int)localAddress.getPort())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if ($this.logger().underlying().isWarnEnabled()) {
                $this.logger().underlying().warn("HTTPS binding failed: {}", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public Server(List<TaskSpecification> tasks, TaskConfig config) {
        this.config = config;
        StrictLogging.$init$((StrictLogging)this);
        this.system = config.actorSystem();
        this.materializer = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)this.system());
        this.service = new Webservice(tasks, this.materializer(), config);
        HttpExt qual$1 = Http$.MODULE$.apply(this.system());
        Function1<RequestContext, Future<RouteResult>> x$1 = this.service().route();
        RoutingSettings x$2 = (RoutingSettings)RoutingSettings$.MODULE$.default((ActorRefFactory)this.system());
        ParserSettings x$3 = (ParserSettings)ParserSettings$.MODULE$.default((ActorRefFactory)this.system());
        Materializer x$4 = this.materializer();
        RoutingLog x$5 = RoutingLog$.MODULE$.fromActorSystem(this.system());
        ExecutionContextExecutor x$6 = this.system().dispatcher();
        RejectionHandler x$7 = RouteResult$.MODULE$.route2HandlerFlow$default$7(x$1);
        ExceptionHandler x$8 = RouteResult$.MODULE$.route2HandlerFlow$default$8(x$1);
        Flow x$9 = RouteResult$.MODULE$.route2HandlerFlow(x$1, x$2, x$3, x$4, x$5, (ExecutionContext)x$6, x$7, x$8);
        String x$10 = config.interface();
        int x$11 = config.httpPort();
        ConnectionContext x$12 = qual$1.bindAndHandle$default$4();
        ServerSettings x$13 = qual$1.bindAndHandle$default$5();
        LoggingAdapter x$14 = qual$1.bindAndHandle$default$6();
        this.httpBinding = qual$1.bindAndHandle(x$9, x$10, x$11, x$12, x$13, x$14, this.materializer());
        this.httpBinding().onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Server.$anonfun$new$1(this, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.system().dispatcher());
        this.httpsServer = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            char[] password = new Scanner(this.getClass().getClassLoader().getResourceAsStream(new StringBuilder(18).append($this.config.serverDomain()).append("-keystore-password").toString())).next().toCharArray();
            KeyStore ks = KeyStore.getInstance("PKCS12");
            InputStream keystore = this.getClass().getClassLoader().getResourceAsStream(new StringBuilder(4).append($this.config.serverDomain()).append(".p12").toString());
            Predef$.MODULE$.require(keystore != null, (Function0 & Serializable & scala.Serializable)() -> "Keystore required!");
            ks.load(keystore, password);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(ks, password);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(keyManagerFactory.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
            HttpsConnectionContext https = ConnectionContext$.MODULE$.https(sslContext, ConnectionContext$.MODULE$.https$default$2(), ConnectionContext$.MODULE$.https$default$3(), ConnectionContext$.MODULE$.https$default$4(), ConnectionContext$.MODULE$.https$default$5(), ConnectionContext$.MODULE$.https$default$6());
            HttpExt qual$2 = Http$.MODULE$.apply(this.system());
            Function1<RequestContext, Future<RouteResult>> x$15 = this.service().route();
            RoutingSettings x$16 = (RoutingSettings)RoutingSettings$.MODULE$.default((ActorRefFactory)this.system());
            ParserSettings x$17 = (ParserSettings)ParserSettings$.MODULE$.default((ActorRefFactory)this.system());
            Materializer x$18 = this.materializer();
            RoutingLog x$19 = RoutingLog$.MODULE$.fromActorSystem(this.system());
            ExecutionContextExecutor x$20 = this.system().dispatcher();
            RejectionHandler x$21 = RouteResult$.MODULE$.route2HandlerFlow$default$7(x$15);
            ExceptionHandler x$22 = RouteResult$.MODULE$.route2HandlerFlow$default$8(x$15);
            Flow x$23 = RouteResult$.MODULE$.route2HandlerFlow(x$15, x$16, x$17, x$18, x$19, (ExecutionContext)x$20, x$21, x$22);
            String x$24 = $this.config.interface();
            int x$25 = $this.config.httpsPort();
            HttpsConnectionContext x$26 = https;
            ServerSettings x$27 = qual$2.bindAndHandle$default$5();
            LoggingAdapter x$28 = qual$2.bindAndHandle$default$6();
            Future httpsBinding = qual$2.bindAndHandle(x$23, x$24, x$25, (ConnectionContext)x$26, x$27, x$28, this.materializer());
            httpsBinding.onComplete((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Server.$anonfun$httpsServer$3(this, x0$2);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.system().dispatcher());
        });
        Try<BoxedUnit> try_ = this.httpsServer();
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("HTTPS configuration failed: {}", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError(try_);
        }
    }
}

