/*
 * Decompiled with CFR 0.152.
 */
package org.jurr.liquibase.releaseplugin.context;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.XMLEvent;
import org.jurr.liquibase.releaseplugin.PrettyPrintXMLEventWriter;
import org.jurr.liquibase.releaseplugin.context.IncludeFile;
import org.jurr.liquibase.releaseplugin.context.LiquibaseProject;

public abstract class DatabaseChangeLogFile {
    public static final String LIQUIBASE_NAMESPACE = "http://www.liquibase.org/xml/ns/dbchangelog";
    protected static final XMLEventFactory XML_EVENT_FACTORY = XMLEventFactory.newInstance();
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private static final XMLOutputFactory XML_OUTPUT_FACTORY;
    public static final QName DATABASE_CHANGELOG_TAG;
    public static final QName CHANGE_SET_TAG;
    public static final QName CHANGE_SET_TAG_ID_ATTRIBUTE;
    public static final QName CHANGE_SET_TAG_AUTHOR_ATTRIBUTE;
    public static final QName CHANGE_SET_TAG_CONTEXT_ATTRIBUTE;
    public static final QName INCLUDE_TAG;
    public static final QName INCLUDE_TAG_FILE_ATTRIBUTE;
    public static final QName INCLUDE_TAG_RELATIVE_TO_CHANGE_LOG_FILE_ATTRIBUTE;
    public static final QName TAG_DATABASE_TAG;
    public static final QName TAG_DATABASE_TAG_ATTRIBUTE;
    private final Path path;
    private boolean fileRead = false;
    private LiquibaseProject liquibaseProject;
    private byte[] newLatestFile;

    DatabaseChangeLogFile(@Nonnull Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("File " + path + " does not exist");
        }
        if (!Files.isReadable(path)) {
            throw new IllegalArgumentException("File " + path + " is not readable");
        }
        this.path = path;
    }

    @Nonnull
    LiquibaseProject getLiquibaseProject() {
        return this.liquibaseProject;
    }

    void setLiquibaseProject(@Nonnull LiquibaseProject liquibaseProject) {
        this.liquibaseProject = liquibaseProject;
    }

    @Nonnull
    Path getPath() {
        return this.path;
    }

    @Nonnull
    byte[] getNewLatestFile() {
        return this.newLatestFile;
    }

    void readFile() {
        if (this.fileRead) {
            return;
        }
        try (BufferedReader masterFileBR = Files.newBufferedReader(this.path, Charset.defaultCharset());
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            XMLEventReader xmlEventReader = XML_INPUT_FACTORY.createXMLEventReader(masterFileBR);
            PrettyPrintXMLEventWriter xmlEventWriter = new PrettyPrintXMLEventWriter(XML_OUTPUT_FACTORY.createXMLEventWriter(baos), "\t");
            block24: while (xmlEventReader.hasNext()) {
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                switch (xmlEvent.getEventType()) {
                    case 7: {
                        StartDocument xmlStartDocument = (StartDocument)xmlEvent;
                        this.readStartDocumentTag(xmlEventReader, xmlStartDocument, xmlEventWriter);
                        continue block24;
                    }
                }
                throw new IllegalArgumentException("Unknown tag in file " + this.path + " at line " + xmlEvent.getLocation().getLineNumber() + ", column " + xmlEvent.getLocation().getColumnNumber());
            }
            xmlEventWriter.flush();
            this.newLatestFile = baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("IO error while reading " + this.path, e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("XML exception while reading " + this.path, e);
        }
        this.fileRead = true;
    }

    abstract void readStartDocumentTag(@Nonnull XMLEventReader var1, @Nonnull StartDocument var2, @Nonnull XMLEventWriter var3) throws XMLStreamException;

    abstract void createNewVersion() throws IOException;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncludeFile other = (IncludeFile)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    static {
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
        XML_OUTPUT_FACTORY.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        DATABASE_CHANGELOG_TAG = new QName(LIQUIBASE_NAMESPACE, "databaseChangeLog");
        CHANGE_SET_TAG = new QName(LIQUIBASE_NAMESPACE, "changeSet");
        CHANGE_SET_TAG_ID_ATTRIBUTE = new QName("", "id");
        CHANGE_SET_TAG_AUTHOR_ATTRIBUTE = new QName("", "author");
        CHANGE_SET_TAG_CONTEXT_ATTRIBUTE = new QName("", "context");
        INCLUDE_TAG = new QName(LIQUIBASE_NAMESPACE, "include");
        INCLUDE_TAG_FILE_ATTRIBUTE = new QName("", "file");
        INCLUDE_TAG_RELATIVE_TO_CHANGE_LOG_FILE_ATTRIBUTE = new QName("", "relativeToChangelogFile");
        TAG_DATABASE_TAG = new QName(LIQUIBASE_NAMESPACE, "tagDatabase");
        TAG_DATABASE_TAG_ATTRIBUTE = new QName("", "tag");
    }
}

