/*
 * Decompiled with CFR 0.152.
 */
package org.jurr.liquibase.releaseplugin.exceptions;

import java.nio.file.Path;
import javax.annotation.Nonnull;

public class VersionAlreadyTaggedException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String version;
    private final Path masterFile;

    public VersionAlreadyTaggedException(@Nonnull String version, @Nonnull Path masterFile) {
        this.version = version;
        this.masterFile = masterFile;
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    @Nonnull
    public Path getMasterFile() {
        return this.masterFile;
    }

    @Override
    public String getMessage() {
        return "Version " + this.version + " already exists in file " + this.masterFile;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.masterFile == null ? 0 : this.masterFile.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionAlreadyTaggedException other = (VersionAlreadyTaggedException)obj;
        if (this.masterFile == null ? other.masterFile != null : !this.masterFile.equals(other.masterFile)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

