/*
 * Decompiled with CFR 0.152.
 */
package org.jurr.liquibase.releaseplugin;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.plexus.util.StringUtils;

public final class Utils {
    private Utils() {
    }

    @Nonnull
    public static Path resolveIncludeFile(@Nonnull Path masterFile, @Nonnull Path includeFile, boolean relativeToChangelogFile, @Nonnull Path classpathRoot) {
        if (!relativeToChangelogFile) {
            return classpathRoot.resolve(includeFile);
        }
        return masterFile.resolveSibling(includeFile);
    }

    @Nonnull
    public static Path replaceStringInPath(@Nonnull Path input, @Nonnull String token, @Nonnull String replacement) {
        return Paths.get(StringUtils.replace((String)input.toString(), (String)token, (String)replacement), new String[0]);
    }

    @Nonnull
    public static String convertPathSeparatorToForwardSlash(@Nonnull Path path) {
        String separator = FileSystems.getDefault().getSeparator();
        return StringUtils.replace((String)path.toString(), (String)separator, (String)"/");
    }

    public static void skipUntillEndElement(@Nonnull XMLEventReader xmlEventReader, @Nonnull StartElement startElement) throws XMLStreamException {
        while (xmlEventReader.hasNext()) {
            EndElement endElement;
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            if (!xmlEvent.isEndElement() || !(endElement = (EndElement)xmlEvent).getName().equals(startElement.getName())) continue;
            return;
        }
        throw new IllegalStateException("End of document reached while searching for end tag for " + startElement.getName());
    }
}

