/*
 * Decompiled with CFR 0.152.
 */
package org.jurr.liquibase.releaseplugin.context;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jurr.liquibase.releaseplugin.Utils;
import org.jurr.liquibase.releaseplugin.context.DatabaseChangeLogFile;
import org.jurr.liquibase.releaseplugin.context.MasterFile;

public class IncludeFile
extends DatabaseChangeLogFile {
    private static final String PART_OF_FILENAME_THAT_WILL_BE_REPLACED_WITH_VERSION = "latest";
    private final MasterFile masterFile;
    private boolean containsChangeSets;

    IncludeFile(@Nonnull Path path, @Nonnull MasterFile masterFile, boolean relativeToChangelogFile, @Nonnull Path classpathRoot) {
        super(Utils.resolveIncludeFile(masterFile.getPath(), path, relativeToChangelogFile, classpathRoot));
        this.masterFile = masterFile;
    }

    public boolean willBeTagged() {
        boolean shouldBeSkipped = this.masterFile.getLiquibaseProject().getIncludeFilesToSkipTagging().contains(this.getPath());
        return !shouldBeSkipped && this.containsChangeSets();
    }

    private boolean containsChangeSets() {
        this.readFile();
        return this.containsChangeSets;
    }

    @Nonnull
    Path getNewVersionFilename(boolean relativeToChangelogFile) {
        Path newVersionFilename = Utils.replaceStringInPath(this.getPath(), PART_OF_FILENAME_THAT_WILL_BE_REPLACED_WITH_VERSION, this.getLiquibaseProject().getNewVersion());
        if (relativeToChangelogFile) {
            return this.masterFile.getPath().getParent().relativize(newVersionFilename);
        }
        return newVersionFilename;
    }

    @Override
    void readStartDocumentTag(@Nonnull XMLEventReader xmlEventReader, @Nonnull StartDocument startDocument, @Nonnull XMLEventWriter xmlEventWriter) throws XMLStreamException {
        xmlEventWriter.add(startDocument);
        block3: while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            switch (xmlEvent.getEventType()) {
                case 1: {
                    StartElement xmlStartElement = (StartElement)xmlEvent;
                    if (xmlStartElement.getName().equals(CHANGE_SET_TAG)) {
                        this.containsChangeSets = true;
                        Utils.skipUntillEndElement(xmlEventReader, xmlStartElement);
                        continue block3;
                    }
                    xmlEventWriter.add(xmlEvent);
                    continue block3;
                }
            }
            xmlEventWriter.add(xmlEvent);
        }
    }

    @Override
    void createNewVersion() throws IOException {
        this.readFile();
        if (!this.willBeTagged()) {
            return;
        }
        Path newFile = this.getNewVersionFilename(false);
        Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
        Files.move(this.getPath(), newFile, new CopyOption[0]);
        Files.write(this.getPath(), this.getNewLatestFile(), StandardOpenOption.CREATE_NEW);
    }
}

