/*
 * Decompiled with CFR 0.152.
 */
package org.jurr.liquibase.releaseplugin;

import javax.annotation.Nonnull;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;

public class PrettyPrintXMLEventWriter
implements XMLEventWriter {
    private static final XMLEventFactory XML_EVENT_FACTORY = XMLEventFactory.newInstance();
    private final XMLEventWriter wrappedWriter;
    private final String indentPrefix;
    private int indent = 0;
    private boolean lastEventWasNewline = false;
    private boolean forLastEventWasNewline = false;

    public PrettyPrintXMLEventWriter(@Nonnull XMLEventWriter wrappedWriter, @Nonnull String indentPrefix) {
        this.wrappedWriter = wrappedWriter;
        this.indentPrefix = indentPrefix;
    }

    @Nonnull
    public String getIndentPrefix() {
        return this.indentPrefix;
    }

    @Override
    public void flush() throws XMLStreamException {
        this.wrappedWriter.flush();
    }

    @Override
    public void close() throws XMLStreamException {
        this.wrappedWriter.close();
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        if (event.isEndElement()) {
            --this.indent;
        }
        if (event.isCharacters()) {
            Characters characters = (Characters)event;
            for (int i = 0; i < characters.getData().length(); ++i) {
                char c = characters.getData().charAt(i);
                if (c != '\n') continue;
                if (!this.lastEventWasNewline) {
                    this.wrappedWriter.add(XML_EVENT_FACTORY.createCharacters("\n"));
                    this.lastEventWasNewline = true;
                    this.forLastEventWasNewline = false;
                    continue;
                }
                if (this.forLastEventWasNewline) continue;
                this.wrappedWriter.add(XML_EVENT_FACTORY.createCharacters("\n"));
                this.forLastEventWasNewline = true;
            }
        } else {
            if (this.lastEventWasNewline) {
                for (int i = 0; i < this.indent; ++i) {
                    this.wrappedWriter.add(XML_EVENT_FACTORY.createCharacters(this.indentPrefix));
                }
            }
            this.wrappedWriter.add(event);
            this.lastEventWasNewline = false;
        }
        if (event.isStartElement()) {
            ++this.indent;
        }
        if (event.isStartDocument()) {
            this.add(XML_EVENT_FACTORY.createCharacters("\n"));
        }
    }

    @Override
    public void add(XMLEventReader reader) throws XMLStreamException {
        this.wrappedWriter.add(reader);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.wrappedWriter.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.wrappedWriter.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.wrappedWriter.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.wrappedWriter.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.wrappedWriter.getNamespaceContext();
    }
}

