/*
 * Decompiled with CFR 0.152.
 */
package org.jurr.liquibase.releaseplugin.context;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.plexus.util.StringUtils;
import org.jurr.liquibase.releaseplugin.Utils;
import org.jurr.liquibase.releaseplugin.context.DatabaseChangeLogFile;
import org.jurr.liquibase.releaseplugin.context.IncludeFile;
import org.jurr.liquibase.releaseplugin.exceptions.VersionAlreadyTaggedException;

public class MasterFile
extends DatabaseChangeLogFile {
    private final List<IncludeFile> includedFiles = new ArrayList<IncludeFile>();
    private boolean bufferingXMLEvents = false;
    private List<XMLEvent> bufferedXMLEvents = new LinkedList<XMLEvent>();

    public MasterFile(@Nonnull Path path) {
        super(path);
    }

    private void addXMLEventToOutput(@Nonnull XMLEventWriter xmlEventWriter, @Nonnull XMLEvent xmlEvent) throws XMLStreamException {
        if (this.bufferingXMLEvents) {
            this.bufferedXMLEvents.add(xmlEvent);
        } else {
            xmlEventWriter.add(xmlEvent);
        }
    }

    private void flushBufferedXMLEvents(@Nonnull XMLEventWriter xmlEventWriter) throws XMLStreamException {
        if (this.bufferingXMLEvents) {
            for (XMLEvent xmlEvent : this.bufferedXMLEvents) {
                xmlEventWriter.add(xmlEvent);
            }
            this.bufferedXMLEvents.clear();
            this.bufferingXMLEvents = false;
        }
    }

    @Override
    void readStartDocumentTag(@Nonnull XMLEventReader xmlEventReader, @Nonnull StartDocument startDocumentElement, @Nonnull XMLEventWriter xmlEventWriter) throws XMLStreamException {
        xmlEventWriter.add(startDocumentElement);
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            switch (xmlEvent.getEventType()) {
                case 1: {
                    StartElement xmlStartElement = (StartElement)xmlEvent;
                    if (xmlStartElement.getName().equals(DATABASE_CHANGELOG_TAG)) {
                        this.addXMLEventToOutput(xmlEventWriter, xmlEvent);
                        break;
                    }
                    if (xmlStartElement.getName().equals(INCLUDE_TAG)) {
                        this.readIncludeTag(xmlStartElement);
                        this.bufferingXMLEvents = true;
                        this.addXMLEventToOutput(xmlEventWriter, xmlEvent);
                        break;
                    }
                    if (xmlStartElement.getName().equals(CHANGE_SET_TAG)) {
                        this.addXMLEventToOutput(xmlEventWriter, xmlEvent);
                        String taggedVersion = this.readChangeSetTag(xmlEventReader, xmlEventWriter);
                        if (taggedVersion == null) break;
                        if (taggedVersion.equals(this.getLiquibaseProject().getNewVersion())) {
                            throw new VersionAlreadyTaggedException(this.getLiquibaseProject().getNewVersion(), this.getPath());
                        }
                        this.includedFiles.clear();
                        this.flushBufferedXMLEvents(xmlEventWriter);
                        break;
                    }
                    throw new IllegalArgumentException("Unknown tag in file " + this.getPath() + " at line " + xmlEvent.getLocation().getLineNumber() + ", column " + xmlEvent.getLocation().getColumnNumber());
                }
                case 2: {
                    EndElement xmlEndElement = (EndElement)xmlEvent;
                    if (xmlEndElement.getName().equals(DATABASE_CHANGELOG_TAG)) {
                        this.bufferingXMLEvents = true;
                    }
                    this.addXMLEventToOutput(xmlEventWriter, xmlEvent);
                    break;
                }
                default: {
                    this.addXMLEventToOutput(xmlEventWriter, xmlEvent);
                }
            }
        }
        for (int i = 0; i < this.includedFiles.size(); ++i) {
            IncludeFile includeFile = this.includedFiles.get(i);
            IncludeFile actualIncludeFile = this.getLiquibaseProject().addIncludeFile(includeFile);
            this.includedFiles.set(i, actualIncludeFile);
        }
        this.insertNewVersionIncludesAndTag(xmlEventWriter);
        this.flushBufferedXMLEvents(xmlEventWriter);
    }

    private void readIncludeTag(@Nonnull StartElement includeStartElement) {
        Path includeFilePath = Paths.get(includeStartElement.getAttributeByName(INCLUDE_TAG_FILE_ATTRIBUTE).getValue(), new String[0]);
        String relativeToChangelogFileString = includeStartElement.getAttributeByName(INCLUDE_TAG_RELATIVE_TO_CHANGE_LOG_FILE_ATTRIBUTE).getValue();
        boolean relativeToChangelogFile = Boolean.valueOf(relativeToChangelogFileString);
        IncludeFile includeFile = new IncludeFile(includeFilePath, this, relativeToChangelogFile, this.getLiquibaseProject().getClasspathRoot());
        this.includedFiles.add(includeFile);
    }

    @CheckForNull
    private String readChangeSetTag(@Nonnull XMLEventReader xmlEventReader, @Nonnull XMLEventWriter xmlEventWriter) throws XMLStreamException {
        String lastFoundTag = null;
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            this.addXMLEventToOutput(xmlEventWriter, xmlEvent);
            switch (xmlEvent.getEventType()) {
                case 1: {
                    StartElement xmlStartElement = (StartElement)xmlEvent;
                    if (!xmlStartElement.getName().equals(TAG_DATABASE_TAG)) break;
                    lastFoundTag = xmlStartElement.getAttributeByName(TAG_DATABASE_TAG_ATTRIBUTE).getValue();
                    break;
                }
                case 2: {
                    EndElement xmlEndElement = (EndElement)xmlEvent;
                    if (!xmlEndElement.getName().equals(CHANGE_SET_TAG)) break;
                    return lastFoundTag;
                }
            }
        }
        throw new IllegalArgumentException("No end tag found for <changeSet> tag");
    }

    private void insertNewVersionIncludesAndTag(@Nonnull XMLEventWriter xmlEventWriter) throws XMLStreamException, FactoryConfigurationError {
        String newVersion = this.getLiquibaseProject().getNewVersion();
        xmlEventWriter.add(XML_EVENT_FACTORY.createCharacters("\n\n"));
        xmlEventWriter.add(XML_EVENT_FACTORY.createComment(" Version " + newVersion + " "));
        xmlEventWriter.add(XML_EVENT_FACTORY.createCharacters("\n"));
        for (IncludeFile includeFile : this.includedFiles) {
            if (!includeFile.willBeTagged()) continue;
            String newVersionFilename = Utils.convertPathSeparatorToForwardSlash(includeFile.getNewVersionFilename(true));
            Attribute file = XML_EVENT_FACTORY.createAttribute(INCLUDE_TAG_FILE_ATTRIBUTE, newVersionFilename);
            Attribute relativeToChangelogFile = XML_EVENT_FACTORY.createAttribute(INCLUDE_TAG_RELATIVE_TO_CHANGE_LOG_FILE_ATTRIBUTE, "true");
            xmlEventWriter.add(XML_EVENT_FACTORY.createStartElement(INCLUDE_TAG, Arrays.asList(file, relativeToChangelogFile).iterator(), null));
            xmlEventWriter.add(XML_EVENT_FACTORY.createEndElement(INCLUDE_TAG, null));
            xmlEventWriter.add(XML_EVENT_FACTORY.createCharacters("\n"));
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(3);
        attributes.add(XML_EVENT_FACTORY.createAttribute(CHANGE_SET_TAG_ID_ATTRIBUTE, "Tag " + newVersion));
        attributes.add(XML_EVENT_FACTORY.createAttribute(CHANGE_SET_TAG_AUTHOR_ATTRIBUTE, "liquibase-db-release"));
        if (StringUtils.isNotBlank((String)this.getLiquibaseProject().getContext())) {
            attributes.add(XML_EVENT_FACTORY.createAttribute(CHANGE_SET_TAG_CONTEXT_ATTRIBUTE, this.getLiquibaseProject().getContext()));
        }
        xmlEventWriter.add(XML_EVENT_FACTORY.createStartElement(CHANGE_SET_TAG, attributes.iterator(), null));
        xmlEventWriter.add(XML_EVENT_FACTORY.createCharacters("\n"));
        Attribute tag = XML_EVENT_FACTORY.createAttribute(TAG_DATABASE_TAG_ATTRIBUTE, newVersion);
        xmlEventWriter.add(XML_EVENT_FACTORY.createStartElement(TAG_DATABASE_TAG, Arrays.asList(tag).iterator(), null));
        xmlEventWriter.add(XML_EVENT_FACTORY.createEndElement(TAG_DATABASE_TAG, null));
        xmlEventWriter.add(XML_EVENT_FACTORY.createCharacters("\n"));
        xmlEventWriter.add(XML_EVENT_FACTORY.createEndElement(CHANGE_SET_TAG, null));
        xmlEventWriter.add(XML_EVENT_FACTORY.createCharacters("\n\n"));
    }

    @Override
    void createNewVersion() throws IOException {
        this.readFile();
        Files.write(this.getPath(), this.getNewLatestFile(), new OpenOption[0]);
    }
}

