/*
 * Decompiled with CFR 0.152.
 */
package org.jurr.liquibase.releaseplugin;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;
import org.jurr.liquibase.releaseplugin.context.LiquibaseProject;
import org.jurr.liquibase.releaseplugin.context.MasterFile;

@Mojo(name="tag", defaultPhase=LifecyclePhase.NONE)
public class TagDatabaseMojo
extends AbstractMojo {
    @Parameter(required=true)
    private Set<File> masterFiles;
    @Parameter
    private Set<File> skippedIncludeFiles;
    @Parameter(property="newVersion")
    private String newVersion;
    @Parameter(property="context", required=false)
    private String context;
    @Component
    private Prompter prompter;
    @Parameter(property="settings", readonly=true, required=true)
    private Settings settings;
    @Parameter(property="classpathRoot", required=true, defaultValue="${project.build.resources[0].directory}")
    private File classpathRoot;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.retrieveNewVersion();
        LiquibaseProject liquibaseProject = new LiquibaseProject(this.newVersion, this.context, this.classpathRoot.toPath());
        for (File masterFile : this.masterFiles) {
            liquibaseProject.addMasterFile(new MasterFile(masterFile.toPath()));
        }
        if (this.skippedIncludeFiles != null) {
            for (File skippedIncludeFile : this.skippedIncludeFiles) {
                liquibaseProject.addIncludeFileToSkipTagging(skippedIncludeFile.toPath());
            }
        }
        try {
            liquibaseProject.createNewVersion();
        }
        catch (IOException e) {
            throw new MojoFailureException("IO exception while creating new version", (Throwable)e);
        }
    }

    private void retrieveNewVersion() throws MojoExecutionException {
        if (StringUtils.isEmpty((String)this.newVersion) && this.settings.isInteractiveMode()) {
            try {
                this.newVersion = this.prompter.prompt("Enter the new version to set");
            }
            catch (PrompterException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        if (StringUtils.isEmpty((String)this.newVersion)) {
            throw new MojoExecutionException("You must specify the new version, either by using the newVersion property (that is -DnewVersion=... on the command line) or run in interactive mode");
        }
    }
}

