/*
 * Decompiled with CFR 0.152.
 */
package org.jurr.liquibase.releaseplugin.context;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jurr.liquibase.releaseplugin.Utils;
import org.jurr.liquibase.releaseplugin.context.IncludeFile;
import org.jurr.liquibase.releaseplugin.context.MasterFile;

public class LiquibaseProject {
    private final Set<MasterFile> masterFiles = new HashSet<MasterFile>();
    private final String newVersion;
    private final Set<Path> includeFilesToSkipTagging = new HashSet<Path>();
    private final List<IncludeFile> includeFiles = new ArrayList<IncludeFile>();
    private final String context;
    private final Path classpathRoot;

    public LiquibaseProject(@Nonnull String newVersion, String context, @Nonnull Path classpathRoot) {
        this.newVersion = newVersion;
        this.context = context;
        this.classpathRoot = classpathRoot;
    }

    @CheckForNull
    public String getContext() {
        return this.context;
    }

    @Nonnull
    public Set<MasterFile> getMasterFiles() {
        return Collections.unmodifiableSet(this.masterFiles);
    }

    public void addMasterFile(@Nonnull MasterFile masterFile) {
        masterFile.setLiquibaseProject(this);
        this.masterFiles.add(masterFile);
    }

    @Nonnull
    public String getNewVersion() {
        return this.newVersion;
    }

    @Nonnull
    Path getClasspathRoot() {
        return this.classpathRoot;
    }

    @Nonnull
    public Set<Path> getIncludeFilesToSkipTagging() {
        return Collections.unmodifiableSet(this.includeFilesToSkipTagging);
    }

    public void addIncludeFileToSkipTagging(@Nonnull MasterFile masterFile, @Nonnull String uri) {
        this.addIncludeFileToSkipTagging(masterFile, Paths.get(uri, new String[0]));
    }

    public void addIncludeFileToSkipTagging(@Nonnull MasterFile masterFile, @Nonnull Path path) {
        this.includeFilesToSkipTagging.add(Utils.resolveIncludeFile(masterFile.getPath(), path, true, this.classpathRoot));
    }

    public void addIncludeFileToSkipTagging(@Nonnull String uri) {
        this.addIncludeFileToSkipTagging(Paths.get(uri, new String[0]));
    }

    public void addIncludeFileToSkipTagging(@Nonnull Path path) {
        this.includeFilesToSkipTagging.add(path);
    }

    public void createNewVersion() throws IOException {
        for (MasterFile masterFile : this.masterFiles) {
            masterFile.createNewVersion();
        }
        for (IncludeFile includeFile : this.includeFiles) {
            includeFile.createNewVersion();
        }
    }

    @Nonnull
    IncludeFile addIncludeFile(@Nonnull IncludeFile includeFile) {
        int includeFileIndex = this.includeFiles.indexOf(includeFile);
        if (includeFileIndex == -1) {
            includeFile.setLiquibaseProject(this);
            this.includeFiles.add(includeFile);
            return includeFile;
        }
        return this.includeFiles.get(includeFileIndex);
    }
}

