/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.ext;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import liquibase.change.Change;
import liquibase.change.core.TagDatabaseChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.LiquibaseException;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.ext.EnversSupportUtils;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtils;
import org.jurr.liquibase.envers.TemplateSupportChange;

public class EnversSupportParser
implements ChangeLogParser {
    public static final String ENVERS_SUPPORT_CHANGESET_AUTHOR = "liquibase-envers-support plugin";
    public static final String VERSION_NAME_AFTER_LAST_TAG = "develop";

    public int getPriority() {
        return 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        ChangeLogParserFactory changeLogParserFactory = ChangeLogParserFactory.getInstance();
        changeLogParserFactory.unregister((ChangeLogParser)this);
        try {
            ChangeLogParser previousParser;
            try {
                previousParser = changeLogParserFactory.getParser(physicalChangeLogLocation, resourceAccessor);
            }
            catch (LiquibaseException e) {
                throw new ChangeLogParseException("Could not get previous parser.", (Throwable)e);
            }
            DatabaseChangeLog databaseChangeLog = previousParser.parse(physicalChangeLogLocation, changeLogParameters, resourceAccessor);
            this.addEnversChangeSets(databaseChangeLog);
            DatabaseChangeLog databaseChangeLog2 = databaseChangeLog;
            return databaseChangeLog2;
        }
        finally {
            changeLogParserFactory.register((ChangeLogParser)this);
        }
    }

    private void addEnversChangeSets(DatabaseChangeLog databaseChangeLog) {
        List changeSets = databaseChangeLog.getChangeSets();
        LinkedList<TagDatabaseChange> tagDatabaseChanges = new LinkedList<TagDatabaseChange>();
        ChangeSet enversTemplateChangeSet = this.findTemplatesAndTagDatabaseChangeSets(changeSets, tagDatabaseChanges);
        if (tagDatabaseChanges.isEmpty()) {
            return;
        }
        for (int i = 0; i < tagDatabaseChanges.size(); ++i) {
            String previousVersion = ((TagDatabaseChange)tagDatabaseChanges.get(i)).getTag();
            String currentVersion = tagDatabaseChanges.size() == i + 1 ? VERSION_NAME_AFTER_LAST_TAG : ((TagDatabaseChange)tagDatabaseChanges.get(i + 1)).getTag();
            ChangeSet changeSet = ((TagDatabaseChange)tagDatabaseChanges.get(i)).getChangeSet();
            this.appendEnversChangeSet(databaseChangeLog, changeSet, previousVersion, currentVersion, enversTemplateChangeSet);
        }
    }

    private ChangeSet findTemplatesAndTagDatabaseChangeSets(List<ChangeSet> changeSets, List<TagDatabaseChange> tagDatabaseChanges) {
        ChangeSet enversTemplateChangeSet = null;
        TagDatabaseChange lastFoundTagDatabaseChange = null;
        for (int i = 0; i < changeSets.size(); ++i) {
            ChangeSet changeSet = changeSets.get(i);
            if (enversTemplateChangeSet == null) {
                if (!changeSet.getAuthor().equals(ENVERS_SUPPORT_CHANGESET_AUTHOR)) continue;
                enversTemplateChangeSet = changeSet;
                changeSets.remove(i);
                --i;
                continue;
            }
            TagDatabaseChange tagDatabaseChange = this.findTagDatabaseChangeInChangeSet(changeSet);
            if (tagDatabaseChange != null) {
                lastFoundTagDatabaseChange = tagDatabaseChange;
                continue;
            }
            if (lastFoundTagDatabaseChange == null) continue;
            tagDatabaseChanges.add(lastFoundTagDatabaseChange);
            lastFoundTagDatabaseChange = null;
        }
        return enversTemplateChangeSet;
    }

    private TagDatabaseChange findTagDatabaseChangeInChangeSet(ChangeSet changeSet) {
        List changes = changeSet.getChanges();
        for (int j = 0; j < changes.size(); ++j) {
            Change change = (Change)changes.get(j);
            if (!(change instanceof TagDatabaseChange)) continue;
            return (TagDatabaseChange)change;
        }
        return null;
    }

    private void appendEnversChangeSet(DatabaseChangeLog masterChangeLog, ChangeSet afterChangeSet, String previousVersion, String currentVersion, ChangeSet enversTemplateChangeSet) {
        DatabaseChangeLog changeSetChangeLog = afterChangeSet.getChangeLog();
        String changeSetId = EnversSupportUtils.replacePlaceholders(enversTemplateChangeSet.getId(), previousVersion, currentVersion);
        String contextList = StringUtils.join((Collection)enversTemplateChangeSet.getContexts(), (String)",");
        String dbmsList = StringUtils.join((Collection)enversTemplateChangeSet.getDbmsSet(), (String)",");
        ChangeSet enversChangeSet = new ChangeSet(changeSetId, ENVERS_SUPPORT_CHANGESET_AUTHOR, enversTemplateChangeSet.isAlwaysRun(), enversTemplateChangeSet.isRunOnChange(), afterChangeSet.getFilePath(), contextList, dbmsList, enversTemplateChangeSet.isRunInTransaction(), enversTemplateChangeSet.getObjectQuotingStrategy(), changeSetChangeLog);
        for (Change change : enversTemplateChangeSet.getChanges()) {
            enversChangeSet.addChange((Change)new TemplateSupportChange(change, previousVersion, currentVersion));
        }
        for (Change change : enversTemplateChangeSet.getRollBackChanges()) {
            enversChangeSet.addRollbackChange((Change)new TemplateSupportChange(change, previousVersion, currentVersion));
        }
        int changeSetChangeLogInsertIndex = changeSetChangeLog.getChangeSets().indexOf(afterChangeSet) + 1;
        changeSetChangeLog.getChangeSets().add(changeSetChangeLogInsertIndex, enversChangeSet);
        if (masterChangeLog != changeSetChangeLog) {
            int masterChangeLogInsertIndex = masterChangeLog.getChangeSets().indexOf(afterChangeSet) + 1;
            masterChangeLog.getChangeSets().add(masterChangeLogInsertIndex, enversChangeSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        ChangeLogParserFactory changeLogParserFactory = ChangeLogParserFactory.getInstance();
        changeLogParserFactory.unregister((ChangeLogParser)this);
        try {
            boolean bl = changeLogParserFactory.getParser(changeLogFile, resourceAccessor).supports(changeLogFile, resourceAccessor);
            return bl;
        }
        catch (LiquibaseException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            changeLogParserFactory.register((ChangeLogParser)this);
        }
    }
}

