/*
 * Decompiled with CFR 0.152.
 */
package org.jurr.liquibase.envers;

import java.util.Map;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.exception.RollbackImpossibleException;
import liquibase.parser.ext.EnversSupportUtils;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;
import liquibase.statement.core.InsertStatement;

@DatabaseChange(name="liquibase-envers-support", description="Dummy change that wraps another change just for templateing support", priority=1)
public class TemplateSupportChange
extends AbstractChange {
    private final Change wrappedChange;
    private final String previousVersion;
    private final String currentVersion;

    public TemplateSupportChange(Change wrappedChange, String previousVersion, String currentVersion) {
        this.wrappedChange = wrappedChange;
        this.previousVersion = previousVersion;
        this.currentVersion = currentVersion;
    }

    public String getConfirmationMessage() {
        return EnversSupportUtils.replacePlaceholders(this.wrappedChange.getConfirmationMessage(), this.previousVersion, this.currentVersion);
    }

    public SqlStatement[] generateStatements(Database database) {
        return this.replacePlaceholdersSqlStatements(this.wrappedChange.generateStatements(database), this.previousVersion, this.currentVersion);
    }

    public SqlStatement[] generateRollbackStatements(Database database) throws RollbackImpossibleException {
        return this.replacePlaceholdersSqlStatements(this.wrappedChange.generateRollbackStatements(database), this.previousVersion, this.currentVersion);
    }

    private SqlStatement[] replacePlaceholdersSqlStatements(SqlStatement[] input, String previousVersion, String currentVersion) {
        SqlStatement[] result = new SqlStatement[input.length];
        for (int i = 0; i < result.length; ++i) {
            SqlStatement sqlStatement = input[i];
            result[i] = this.replacePlaceholdersSqlStatement(sqlStatement, previousVersion, currentVersion);
        }
        return result;
    }

    private SqlStatement replacePlaceholdersSqlStatement(SqlStatement input, String previousVersion, String currentVersion) {
        if (input instanceof InsertStatement) {
            return this.replacePlaceholdersSqlStatement((InsertStatement)input, previousVersion, currentVersion);
        }
        if (input instanceof DeleteStatement) {
            return this.replacePlaceholdersSqlStatement((DeleteStatement)input, previousVersion, currentVersion);
        }
        throw new IllegalArgumentException("Envers support plugin does not (yet) work with " + input.getClass().getSimpleName() + " statements - please add it!");
    }

    private InsertStatement replacePlaceholdersSqlStatement(InsertStatement input, String previousVersion, String currentVersion) {
        InsertStatement result = new InsertStatement(input.getCatalogName(), input.getSchemaName(), input.getTableName());
        for (Map.Entry entry : input.getColumnValues().entrySet()) {
            Object newValue = EnversSupportUtils.replacePlaceholders(entry.getValue(), previousVersion, currentVersion);
            result.addColumnValue((String)entry.getKey(), newValue);
        }
        return result;
    }

    private DeleteStatement replacePlaceholdersSqlStatement(DeleteStatement input, String previousVersion, String currentVersion) {
        DeleteStatement result = new DeleteStatement(input.getCatalogName(), input.getSchemaName(), input.getTableName());
        result.setWhere(EnversSupportUtils.replacePlaceholders(input.getWhere(), previousVersion, currentVersion));
        for (Object whereParameter : input.getWhereParameters()) {
            result.addWhereParameter(EnversSupportUtils.replacePlaceholders(whereParameter, previousVersion, currentVersion));
        }
        for (String columnName : input.getWhereColumnNames()) {
            result.addWhereColumnName(EnversSupportUtils.replacePlaceholders(columnName, previousVersion, currentVersion));
        }
        return result;
    }
}

