/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.bitnet.message;

import java.nio.ByteBuffer;
import org.jusecase.bitnet.checksum.Crc32cMessageChecksum;
import org.jusecase.bitnet.checksum.MessageChecksum;
import org.jusecase.bitnet.message.BitMessage;
import org.jusecase.bitpack.AbstractBitProtocol;

public class BitMessageProtocol
extends AbstractBitProtocol {
    public static final byte MULTI_MESSAGE_TYPE = 0;
    public static final int MAX_PACKETS_PER_MESSAGE = 256;
    private final int maxPacketBytes;
    private final int maxPacketsPerMessage;
    private MessageChecksum messageChecksum = new Crc32cMessageChecksum();

    public BitMessageProtocol() {
        this(1024, 32);
    }

    public BitMessageProtocol(int maxPacketBytes, int maxPacketsPerMessage) {
        if (maxPacketsPerMessage <= 0 || maxPacketsPerMessage > 256) {
            throw new IllegalArgumentException("This protocol cannot handle more than 256 packets per message.");
        }
        this.maxPacketBytes = maxPacketBytes;
        this.maxPacketsPerMessage = maxPacketsPerMessage;
    }

    public int getTypeForMessage(BitMessage message) {
        return this.getBitTypes().getTypeForInstance((Object)message);
    }

    public int getMaxPacketBytes() {
        return this.maxPacketBytes;
    }

    public int getEffectiveBytesForFirstPacket() {
        int byteOverheadForFirstPacket = 8;
        return this.maxPacketBytes - byteOverheadForFirstPacket;
    }

    public int getEffectiveBytesForAdditionalPacket() {
        int byteOverheadForAdditionalPackets = 7;
        return this.maxPacketBytes - byteOverheadForAdditionalPackets;
    }

    public int getPacketPosition(int packetNumber) {
        if (packetNumber == 0) {
            return 0;
        }
        return this.getEffectiveBytesForFirstPacket() + (packetNumber - 1) * this.getEffectiveBytesForAdditionalPacket();
    }

    public MessageChecksum getMessageChecksum() {
        return this.messageChecksum;
    }

    public void setMessageChecksum(MessageChecksum messageChecksum) {
        this.messageChecksum = messageChecksum;
    }

    public int getMaxMessageBytes() {
        return this.maxPacketBytes * this.maxPacketsPerMessage;
    }

    public ByteBuffer createPacket() {
        return ByteBuffer.allocateDirect(this.getMaxPacketBytes());
    }

    public ByteBuffer createMultiPartData() {
        return ByteBuffer.allocateDirect(this.getMaxMessageBytes());
    }

    public int getPacketTimeoutInMilliseconds() {
        return 5000;
    }
}

