/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.bitnet.message;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.jusecase.bitnet.checksum.MessageChecksum;
import org.jusecase.bitnet.message.BitMessage;
import org.jusecase.bitnet.message.BitMessageProtocol;
import org.jusecase.bitnet.message.InvalidBitMessageException;
import org.jusecase.bitnet.time.CurrentTimeProvider;
import org.jusecase.bitpack.BitProtocol;
import org.jusecase.bitpack.buffer.BufferBitReader;

public class BitMessageReader {
    private final BitMessageProtocol protocol;
    private final int clientId;
    private final DataForMessageNumber[] dataForMessageNumber;
    private MessageChecksum messageChecksum;
    private CurrentTimeProvider currentTimeProvider;

    public BitMessageReader(BitMessageProtocol protocol, int clientId) {
        this.protocol = protocol;
        this.clientId = clientId;
        this.dataForMessageNumber = new DataForMessageNumber[256];
        for (int i = 0; i < this.dataForMessageNumber.length; ++i) {
            this.dataForMessageNumber[i] = new DataForMessageNumber();
        }
        this.messageChecksum = protocol.getMessageChecksum();
        this.currentTimeProvider = new CurrentTimeProvider();
    }

    public BitMessage read(ByteBuffer packet) throws InvalidBitMessageException {
        ((Buffer)packet).rewind();
        BufferBitReader unpacker = new BufferBitReader((BitProtocol)this.protocol, packet);
        ByteBuffer data = unpacker.getBuffer();
        int receivedChecksum = data.getInt();
        byte messageNumber = data.get();
        data.putInt(0, this.clientId);
        ((Buffer)data).rewind();
        int calculatedChecksum = this.messageChecksum.calculateChecksum(data);
        if (calculatedChecksum != receivedChecksum) {
            throw new InvalidBitMessageException("Invalid checksum, expected " + calculatedChecksum + " received " + receivedChecksum);
        }
        ((Buffer)data).position(5);
        int messageType = unpacker.readInt8();
        if (messageType == 0) {
            return this.readMultipartMessagePacket(packet, messageNumber);
        }
        Class messageClass = this.protocol.getBitTypes().getClassForType(messageType);
        BitMessage message = (BitMessage)unpacker.readObjectNonNull(messageClass);
        message.setMessageNumber(messageNumber);
        return message;
    }

    private BitMessage readMultipartMessagePacket(ByteBuffer packet, byte messageNumber) {
        int index = messageNumber - -128;
        DataForMessageNumber data = this.dataForMessageNumber[index];
        return data.readMultipartMessagePacket(packet);
    }

    public void setMessageChecksum(MessageChecksum messageChecksum) {
        this.messageChecksum = messageChecksum;
    }

    public void setCurrentTimeProvider(CurrentTimeProvider currentTimeProvider) {
        this.currentTimeProvider = currentTimeProvider;
    }

    private class DataForMessageNumber {
        private ByteBuffer multiPartData;
        private int multiPartDataPackets;
        private int multiPartDataPacketsReceived;
        private int multiPartDataSize;
        private long timestampOfLastPacketReceived;

        private DataForMessageNumber() {
        }

        public BitMessage readMultipartMessagePacket(ByteBuffer packet) {
            this.checkTimeout();
            this.extractPacketContent(packet);
            return this.tryToReadMessage();
        }

        private void checkTimeout() {
            long now = BitMessageReader.this.currentTimeProvider.getMillis();
            if (this.timestampOfLastPacketReceived != 0L && now - this.timestampOfLastPacketReceived >= (long)BitMessageReader.this.protocol.getPacketTimeoutInMilliseconds()) {
                this.reset();
            }
            this.timestampOfLastPacketReceived = now;
        }

        private void extractPacketContent(ByteBuffer packet) {
            byte packetNumber;
            if (this.multiPartData == null) {
                this.multiPartData = BitMessageReader.this.protocol.createMultiPartData();
            }
            if ((packetNumber = packet.get()) == 0) {
                this.multiPartDataPackets = packet.get();
            }
            ((Buffer)this.multiPartData).position(BitMessageReader.this.protocol.getPacketPosition(packetNumber));
            this.multiPartData.put(packet);
            this.multiPartDataSize = Math.max(this.multiPartDataSize, this.multiPartData.position());
        }

        private BitMessage tryToReadMessage() {
            ++this.multiPartDataPacketsReceived;
            if (this.multiPartDataPackets == 0 || this.multiPartDataPacketsReceived != this.multiPartDataPackets) {
                return null;
            }
            try {
                ((Buffer)this.multiPartData).limit(this.multiPartDataSize);
                BitMessage bitMessage = BitMessageReader.this.read(this.multiPartData);
                return bitMessage;
            }
            finally {
                this.releaseData();
            }
        }

        private void reset() {
            ((Buffer)this.multiPartData).clear();
            this.multiPartDataPackets = 0;
            this.multiPartDataPacketsReceived = 0;
            this.multiPartDataSize = 0;
            this.timestampOfLastPacketReceived = 0L;
        }

        private void releaseData() {
            this.reset();
            this.multiPartData = null;
        }
    }
}

