/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.bitnet.message;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jusecase.bitnet.checksum.MessageChecksum;
import org.jusecase.bitnet.message.BitMessage;
import org.jusecase.bitnet.message.BitMessageProtocol;
import org.jusecase.bitnet.message.InvalidBitMessageException;
import org.jusecase.bitpack.BitProtocol;
import org.jusecase.bitpack.buffer.BufferBitWriter;

public class BitMessageWriter {
    private final BitMessageProtocol protocol;
    private final int clientId;
    private final BufferBitWriter packer;
    private final PacketSplitter splitter = new PacketSplitter();
    private MessageChecksum messageChecksum;
    private byte nextMessageNumber;

    public BitMessageWriter(BitMessageProtocol protocol, int clientId) {
        this.protocol = protocol;
        this.clientId = clientId;
        this.packer = new BufferBitWriter((BitProtocol)protocol, ByteBuffer.allocateDirect(protocol.getMaxMessageBytes()));
        this.messageChecksum = protocol.getMessageChecksum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ByteBuffer> write(BitMessage message) {
        try {
            this.packer.reset();
            ByteBuffer data = this.writeInOnePacket(message);
            if (data.limit() <= this.protocol.getMaxPacketBytes()) {
                List<ByteBuffer> list = Collections.singletonList(data);
                return list;
            }
            List<ByteBuffer> list = this.writeInMultiplePackets(data);
            return list;
        }
        finally {
            this.increaseNextMessageNumber();
        }
    }

    private void increaseNextMessageNumber() {
        this.nextMessageNumber = (byte)(this.nextMessageNumber + 1);
    }

    private ByteBuffer writeInOnePacket(BitMessage message) {
        try {
            ByteBuffer data = this.packer.getBuffer();
            data.putInt(this.clientId);
            data.put(this.nextMessageNumber);
            int type = this.protocol.getTypeForMessage(message);
            data.put((byte)type);
            this.packer.writeObjectNonNull((Object)message);
            this.packer.flush();
            ((Buffer)data).limit(data.position());
            ((Buffer)data).rewind();
            int checksum = this.messageChecksum.calculateChecksum(data);
            data.putInt(0, checksum);
            ((Buffer)data).rewind();
            return data;
        }
        catch (BufferOverflowException e) {
            throw new InvalidBitMessageException("Maximum message size of " + this.protocol.getMaxMessageBytes() + " bytes exceeded");
        }
    }

    private List<ByteBuffer> writeInMultiplePackets(ByteBuffer data) {
        return this.splitter.split(data);
    }

    public void setMessageChecksum(MessageChecksum messageChecksum) {
        this.messageChecksum = messageChecksum;
    }

    public byte getNextMessageNumber() {
        return this.nextMessageNumber;
    }

    public void setNextMessageNumber(byte nextMessageNumber) {
        this.nextMessageNumber = nextMessageNumber;
    }

    private final class PacketSplitter {
        private ByteBuffer data;
        private List<ByteBuffer> packets;
        private int dataBytes;
        private int effectiveBytesForFirstPacket;
        private int effectiveBytesForAdditionalPacket;
        private int packetCount;

        private PacketSplitter() {
        }

        public List<ByteBuffer> split(ByteBuffer data) {
            this.init(data);
            ByteBuffer packet1 = BitMessageWriter.this.protocol.createPacket();
            this.writePacketPart(0, packet1);
            this.packets.add(packet1);
            for (int packetNumber = 1; packetNumber < this.packetCount; ++packetNumber) {
                ByteBuffer packet = BitMessageWriter.this.protocol.createPacket();
                this.writePacketPart(packetNumber, packet);
                this.packets.add(packet);
            }
            return this.packets;
        }

        private void init(ByteBuffer data) {
            this.packets = new ArrayList<ByteBuffer>();
            this.data = data;
            this.dataBytes = data.limit();
            ((Buffer)data).rewind();
            this.effectiveBytesForFirstPacket = BitMessageWriter.this.protocol.getEffectiveBytesForFirstPacket();
            this.effectiveBytesForAdditionalPacket = BitMessageWriter.this.protocol.getEffectiveBytesForAdditionalPacket();
            this.packetCount = this.calculatePacketCount();
        }

        private int calculatePacketCount() {
            int remainingBytesAfterFirstPacket = this.dataBytes - this.effectiveBytesForFirstPacket;
            int packetCount = remainingBytesAfterFirstPacket / this.effectiveBytesForAdditionalPacket + 1;
            if (remainingBytesAfterFirstPacket % this.effectiveBytesForAdditionalPacket != 0) {
                ++packetCount;
            }
            return packetCount;
        }

        private void writePacketPart(int packetNumber, ByteBuffer packetPart) {
            packetPart.putInt(BitMessageWriter.this.clientId);
            packetPart.put(BitMessageWriter.this.nextMessageNumber);
            packetPart.put((byte)0);
            packetPart.put((byte)packetNumber);
            if (packetNumber == 0) {
                packetPart.put((byte)this.packetCount);
                ((Buffer)this.data).limit(this.effectiveBytesForFirstPacket);
            } else {
                ((Buffer)this.data).limit(Math.min(this.data.position() + this.effectiveBytesForAdditionalPacket, this.dataBytes));
            }
            packetPart.put(this.data);
            ((Buffer)packetPart).limit(packetPart.position());
            ((Buffer)packetPart).rewind();
            int packetChecksum = BitMessageWriter.this.messageChecksum.calculateChecksum(packetPart);
            packetPart.putInt(0, packetChecksum);
            ((Buffer)packetPart).rewind();
        }
    }
}

