/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.bitnet.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.jusecase.bitnet.network.NetworkReceiverListener;

public class NetworkReceiver {
    private final InetSocketAddress host;
    private final NetworkReceiverListener listener;
    private final ByteBuffer packet;
    private DatagramChannel channel;
    private volatile boolean running;

    public NetworkReceiver(InetSocketAddress host, int packetCapacity, NetworkReceiverListener listener) {
        this.host = host;
        this.listener = listener;
        this.packet = ByteBuffer.allocateDirect(packetCapacity);
    }

    public void start() throws IOException {
        if (this.running) {
            throw new IllegalStateException("network receiver is already running");
        }
        this.openChannel();
        this.running = true;
        Thread thread = new Thread(this::listen);
        thread.setName("network-receiver");
        thread.start();
    }

    public void stop() throws IOException {
        this.running = false;
        this.closeChannel();
    }

    private void listen() {
        while (this.running) {
            this.receive();
        }
    }

    private void receive() {
        SocketAddress address = null;
        try {
            address = this.channel.receive(this.packet);
        }
        catch (IOException e) {
            if (!this.running) {
                return;
            }
            this.listener.onErrorReceived(e);
        }
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            ((Buffer)this.packet).limit(this.packet.position());
            ((Buffer)this.packet).position(0);
            this.listener.onPacketReceived(this.packet, inetSocketAddress);
            ((Buffer)this.packet).clear();
        }
    }

    private void openChannel() throws IOException {
        this.channel = DatagramChannel.open();
        this.channel.socket().bind(this.host);
    }

    private void closeChannel() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }
}

