/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.bitnet.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.List;

public class NetworkSender
implements AutoCloseable {
    private final DatagramChannel channel = DatagramChannel.open();

    public NetworkSender() throws IOException {
        this.channel.configureBlocking(true);
    }

    @Override
    public void close() throws IOException {
        this.channel.disconnect();
    }

    public void setBroadcast(boolean broadcast) throws IOException {
        this.channel.socket().setBroadcast(broadcast);
    }

    public void send(InetSocketAddress address, ByteBuffer packet) throws IOException {
        this.channel.send(packet, address);
        ((Buffer)packet).rewind();
    }

    public void send(InetSocketAddress address, List<ByteBuffer> packets) throws IOException {
        for (ByteBuffer packet : packets) {
            this.send(address, packet);
        }
    }
}

