/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.builders.generator;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import org.jusecase.builders.generator.PropertiesResolver;
import org.jusecase.builders.generator.TemplateProcessor;
import org.jusecase.builders.generator.Templates;

public class BuilderGenerator {
    private final Class<?> entityClass;
    private final String lineSeparator;
    private final Charset charset;
    private final Collection<PropertiesResolver.Property> properties;

    public BuilderGenerator(Class<?> entityClass, String encoding, String lineSeparator) {
        this.entityClass = entityClass;
        this.lineSeparator = lineSeparator;
        this.charset = Charset.forName(encoding);
        this.properties = new PropertiesResolver(entityClass).resolveProperties();
    }

    public void generate(OutputStream os) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, this.charset));){
            TemplateProcessor classProcessor = new TemplateProcessor(Templates.BUILDER_CLASS, this.lineSeparator);
            classProcessor.setProperty("package", this.entityClass.getPackage().getName());
            classProcessor.setProperty("builder-class", this.getBuilderClassName());
            classProcessor.setProperty("entity-class", this.getEntityClassName());
            classProcessor.setProperty("body", this.generateBody(classProcessor));
            writer.write(classProcessor.process());
            writer.flush();
        }
    }

    public String getBuilderClassName() {
        if (this.entityClass.getEnclosingClass() == null) {
            return this.entityClass.getSimpleName() + "BuilderMethods";
        }
        return this.entityClass.getEnclosingClass().getSimpleName() + this.entityClass.getSimpleName() + "BuilderMethods";
    }

    private String getEntityClassName() {
        if (this.entityClass.getEnclosingClass() == null) {
            return this.entityClass.getSimpleName();
        }
        return this.entityClass.getEnclosingClass().getSimpleName() + "." + this.entityClass.getSimpleName();
    }

    private String generateBody(TemplateProcessor classProcessor) {
        StringBuilder body = new StringBuilder();
        this.addConstruction(classProcessor, body);
        this.addMethods(classProcessor, body);
        return body.toString();
    }

    private void addMethods(TemplateProcessor classProcessor, StringBuilder body) {
        int remainingProperties = this.properties.size();
        for (PropertiesResolver.Property property : this.properties) {
            this.addMethod(classProcessor, body, property);
            if (--remainingProperties <= 0) continue;
            body.append(this.lineSeparator);
            body.append(this.lineSeparator);
        }
    }

    private void addMethod(TemplateProcessor classProcessor, StringBuilder body, PropertiesResolver.Property property) {
        TemplateProcessor methodProcessor = this.getMethodTemplateProcessor(property);
        methodProcessor.setProperties(classProcessor);
        methodProcessor.setProperty("property-name", property.name);
        methodProcessor.setProperty("property-type", property.getTypeString());
        methodProcessor.setProperty("property-name-starting-with-uppercase", property.nameStartingWithUppercase());
        methodProcessor.setProperty("property-value", "value");
        body.append(methodProcessor.process());
        if (property.type.equals(Date.class)) {
            body.append(this.lineSeparator);
            body.append(this.lineSeparator);
            methodProcessor.setProperties(classProcessor);
            methodProcessor.setProperty("property-type", "String");
            methodProcessor.setProperty("property-value", "org.jusecase.Builders.a(org.jusecase.Builders.date(value))");
            body.append(methodProcessor.process());
        }
    }

    private TemplateProcessor getMethodTemplateProcessor(PropertiesResolver.Property property) {
        if (property.isSetter) {
            return new TemplateProcessor(Templates.BUILDER_METHOD_SETTER, this.lineSeparator);
        }
        return new TemplateProcessor(Templates.BUILDER_METHOD_DIRECT, this.lineSeparator);
    }

    private void addConstruction(TemplateProcessor classProcessor, StringBuilder body) {
        TemplateProcessor constructionProcessor = new TemplateProcessor(Templates.BUILDER_CONSTRUCTION, this.lineSeparator);
        constructionProcessor.setProperties(classProcessor);
        body.append(constructionProcessor.process());
        body.append(this.lineSeparator);
        body.append(this.lineSeparator);
    }

    public boolean isBuildable() {
        return !this.properties.isEmpty();
    }
}

