/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.builders.generator;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.TreeSet;

public class PropertiesResolver {
    private final Class<?> entityClass;

    public PropertiesResolver(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public Collection<Property> resolveProperties() {
        TreeSet<Property> properties = new TreeSet<Property>();
        this.addProperties(this.entityClass, properties);
        return properties;
    }

    private void addProperties(Class<?> clazz, Collection<Property> properties) {
        if (clazz != null && clazz != Object.class) {
            this.addPublicFields(clazz, properties);
            this.addSetterMethods(clazz, properties);
            this.addProperties(clazz.getSuperclass(), properties);
        }
    }

    private void addPublicFields(Class<?> clazz, Collection<Property> properties) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!this.isSuitableField(field)) continue;
            Property property = new Property();
            property.name = field.getName();
            property.type = field.getType();
            property.isSetter = false;
            properties.add(property);
        }
    }

    private void addSetterMethods(Class<?> clazz, Collection<Property> properties) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!this.isSuitableMethod(method)) continue;
            Property property = new Property();
            property.name = method.getName().substring(3);
            property.type = method.getParameterTypes()[0];
            property.isSetter = true;
            properties.add(property);
        }
    }

    private boolean isSuitableField(Field field) {
        return Modifier.isPublic(field.getModifiers()) && !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    }

    private boolean isSuitableMethod(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 1 && method.getName().matches("^set[A-Z].*");
    }

    public static class Property
    implements Comparable<Property> {
        public String name;
        public Class<?> type;
        public boolean isSetter;

        public String getTypeString() {
            if (this.type.getPackage() == null || "java.lang".equals(this.type.getPackage().getName())) {
                return this.correctNestedTypeName(this.type.getSimpleName());
            }
            return this.correctNestedTypeName(this.type.getName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Property property = (Property)o;
            return this.name.equals(property.name) && this.type.equals(property.type);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        @Override
        public int compareTo(Property o) {
            int result = this.name.compareTo(o.name);
            if (result == 0) {
                result = this.type.getName().compareTo(o.type.getName());
            }
            return result;
        }

        private String correctNestedTypeName(String typeName) {
            return typeName.replace('$', '.');
        }

        public String nameStartingWithUppercase() {
            return ("" + this.name.charAt(0)).toUpperCase() + this.name.substring(1);
        }
    }
}

