/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.builders.generator;

import java.util.HashMap;
import java.util.Map;
import org.jusecase.builders.generator.Template;

public class TemplateProcessor {
    private final Template template;
    private final String lineSeparator;
    private final Map<String, String> properties;

    public TemplateProcessor(Template template, String lineSeparator) {
        this.template = template;
        this.lineSeparator = lineSeparator;
        this.properties = new HashMap<String, String>();
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String process() {
        String content = this.template.getContent();
        if (!"\n".equals(this.lineSeparator)) {
            content = content.replace("\n", this.lineSeparator);
        }
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            content = content.replace("${" + property.getKey() + "}", property.getValue());
        }
        return content;
    }

    public void setProperties(TemplateProcessor processor) {
        this.properties.putAll(processor.properties);
    }
}

