/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.builders.generator.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jusecase.builders.generator.BuildersGenerator;
import org.jusecase.builders.generator.maven.LineSeparator;

@Mojo(name="generate-builders", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class BuildersGeneratorMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    public MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/jusecase-builders", property="builders.targetDirectory")
    public String targetDirectory;
    @Parameter(property="builders.packages")
    public String[] packages;
    @Parameter(property="builders.classes")
    public String[] classes;
    @Parameter(property="builders.nestedClasses")
    public boolean nestedClasses = true;
    @Parameter(property="builders.lineSeparator")
    public String lineSeparator = LineSeparator.System.toString();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().info((CharSequence)"Generating builder interfaces...");
            BuildersGenerator generator = new BuildersGenerator(this.getProjectClassLoader(), new File(this.targetDirectory), this.packages, this.classes, this.nestedClasses, LineSeparator.fromString((String)this.lineSeparator).value);
            generator.generate();
            this.getLog().info((CharSequence)("Builder interfaces generated at " + this.targetDirectory));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private ClassLoader getProjectClassLoader() throws DependencyResolutionRequiredException, MalformedURLException {
        ArrayList classpathElements = new ArrayList(this.project.getCompileClasspathElements());
        classpathElements.addAll(this.project.getTestClasspathElements());
        ArrayList<URL> classpathElementUrls = new ArrayList<URL>(classpathElements.size());
        for (String classpathElement : classpathElements) {
            classpathElementUrls.add(new File(classpathElement).toURI().toURL());
        }
        return new URLClassLoader(classpathElementUrls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }
}

