/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.inject;

import javax.inject.Provider;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jusecase.inject.ComponentTest;
import org.jusecase.inject.Injector;
import org.jusecase.inject.InjectorException;
import org.jusecase.inject.PerClassProvider;
import org.jusecase.inject.classes.BeanWithConstructorInjection;
import org.jusecase.inject.classes.BeanWithFinalField;
import org.jusecase.inject.classes.BeanWithNamedDependency;
import org.jusecase.inject.classes.DataSource;
import org.jusecase.inject.classes.DataSourceMock;
import org.jusecase.inject.classes.DataSourceProvider;
import org.jusecase.inject.classes.DataSourceUser;
import org.jusecase.inject.classes.Formatter;
import org.jusecase.inject.classes.LoggerProvider;
import org.jusecase.inject.classes.LoggerUser1;
import org.jusecase.inject.classes.LoggerUser2;
import org.jusecase.inject.classes.TestDriver;
import org.jusecase.inject.classes.TestDriverDb1;
import org.jusecase.inject.classes.TestDriverDb2;
import org.jusecase.inject.classes.TestDriverSubclass;
import org.jusecase.inject.classes.TestGateway;
import org.jusecase.inject.classes.TestService;
import org.jusecase.inject.classes.TestServiceSubclass;

public class InjectorTest
implements ComponentTest {
    @Test
    void named() {
        this.givenDependency("host", "localhost");
        this.givenDependency("user", "root");
        DataSource dataSource = new DataSource();
        Assertions.assertThat((String)dataSource.getHostName()).isEqualTo((Object)"localhost");
        Assertions.assertThat((String)dataSource.getUserName()).isEqualTo((Object)"root");
    }

    @Test
    void named_tooMany() {
        this.givenDependency("host", "localhost");
        this.givenDependency("user1", "root1");
        this.givenDependency("user2", "root2");
        this.givenDependency("user3", "root3");
        Throwable throwable = Assertions.catchThrowable(DataSource::new);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isInstanceOf(InjectorException.class)).hasMessage("No dependency named user, got [host, user1, user2, user3]. Failed to inject java.lang.String userName in org.jusecase.inject.classes.DataSource");
    }

    @Test
    void named_none() {
        Throwable throwable = Assertions.catchThrowable(DataSource::new);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isInstanceOf(InjectorException.class)).hasMessage("No dependency named host. Failed to inject java.lang.String hostName in org.jusecase.inject.classes.DataSource");
    }

    @Test
    void service() {
        TestDriver testDriver = new TestDriver();
        this.givenDependency(testDriver);
        TestGateway testGateway = new TestGateway();
        this.givenDependency(testGateway);
        TestService testService = new TestService();
        Assertions.assertThat((Object)testService.getGateway()).isSameAs((Object)testGateway);
        Assertions.assertThat((Object)testService.getGateway2()).isSameAs((Object)testGateway);
        Assertions.assertThat((Object)testService.getGateway().getDriver()).isSameAs((Object)testDriver);
    }

    @Test
    void serviceSubclass() {
        TestDriver testDriver = new TestDriver();
        this.givenDependency(testDriver);
        TestGateway testGateway = new TestGateway();
        this.givenDependency(testGateway);
        TestServiceSubclass testService = new TestServiceSubclass();
        Assertions.assertThat((Object)testService.getGateway()).isSameAs((Object)testGateway);
        Assertions.assertThat((Object)testService.getGateway2()).isSameAs((Object)testGateway);
        Assertions.assertThat((Object)testService.getGateway().getDriver()).isSameAs((Object)testDriver);
        Assertions.assertThat((Object)testService.getDriver()).isSameAs((Object)testDriver);
    }

    @Test
    void provider() {
        Injector.getInstance().addProvider(DataSourceProvider.class);
        this.givenDependency("host", "localhost");
        this.givenDependency("user", "root");
        DataSourceUser dataSourceUser1 = new DataSourceUser();
        DataSourceUser dataSourceUser2 = new DataSourceUser();
        Assertions.assertThat((Object)dataSourceUser1.dataSource).isNotNull();
        Assertions.assertThat((Object)dataSourceUser1.dataSource).isNotSameAs((Object)dataSourceUser2.dataSource);
    }

    @Test
    void provider_singleInstance() {
        this.givenDependency("host", "localhost");
        this.givenDependency("user", "root");
        Injector.getInstance().addProviderForSingleInstance(DataSourceProvider.class);
        DataSourceUser dataSourceUser1 = new DataSourceUser();
        DataSourceUser dataSourceUser2 = new DataSourceUser();
        Assertions.assertThat((Object)dataSourceUser1.dataSource).isNotNull();
        Assertions.assertThat((Object)dataSourceUser1.dataSource).isSameAs((Object)dataSourceUser2.dataSource);
    }

    @Test
    void providerLookup() {
        DataSourceProvider provider = new DataSourceProvider();
        Injector.getInstance().addProvider((Provider)provider);
        DataSourceProvider resolvedProvider = (DataSourceProvider)Injector.getInstance().resolve(DataSourceProvider.class);
        Assertions.assertThat((Object)resolvedProvider).isSameAs((Object)provider);
    }

    @Test
    void bean_noServiceToInject() {
        Throwable throwable = Assertions.catchThrowable(() -> {
            Formatter formatter = new Formatter("foo", "bar");
        });
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isInstanceOf(InjectorException.class)).hasMessage("No implementation found. Failed to inject org.jusecase.inject.classes.TestService service in org.jusecase.inject.classes.Formatter");
    }

    @Test
    void bean_finalField() {
        this.givenDependency("some string");
        Throwable throwable = Assertions.catchThrowable(BeanWithFinalField::new);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isInstanceOf(InjectorException.class)).hasMessage("@Inject field must not be final. Failed to inject java.lang.String something in org.jusecase.inject.classes.BeanWithFinalField");
    }

    @Test
    void bean() {
        TestDriver testDriver = new TestDriver();
        this.givenDependency(testDriver);
        TestGateway testGateway = new TestGateway();
        this.givenDependency(testGateway);
        TestService testService = new TestService();
        this.givenDependency(testService);
        Formatter formatter = new Formatter("foo", "bar");
        String result = formatter.getResult();
        Assertions.assertThat((String)result).isEqualTo((Object)"service said: foobar");
    }

    @Test
    void addBeanWithName() {
        this.givenDependency(new TestDriverDb1());
        this.givenDependency(new TestDriverDb2());
        BeanWithNamedDependency bean = new BeanWithNamedDependency();
        Assertions.assertThat((Object)bean.driver1).isNotSameAs((Object)bean.driver2);
    }

    @Test
    void addBeanWithNameAsClass() {
        this.givenDependency(TestDriverDb1.class);
        this.givenDependency(TestDriverDb2.class);
        BeanWithNamedDependency bean = new BeanWithNamedDependency();
        Assertions.assertThat((Object)bean.driver1).isNotNull();
        Assertions.assertThat((Object)bean.driver2).isNotNull();
        Assertions.assertThat((Object)bean.driver1).isNotSameAs((Object)bean.driver2);
    }

    @Test
    void logger() {
        Injector.getInstance().addProvider((PerClassProvider)new LoggerProvider());
        LoggerUser1 loggerUser1 = new LoggerUser1();
        LoggerUser2 loggerUser2 = new LoggerUser2();
        Assertions.assertThat(loggerUser1.logger.getClazz()).isEqualTo(LoggerUser1.class);
        Assertions.assertThat(loggerUser2.logger.getClazz()).isEqualTo(LoggerUser2.class);
    }

    @Test
    void constructorInjection() {
        this.givenDependency(new TestDriver());
        Injector.getInstance().add(BeanWithConstructorInjection.class);
    }

    @Test
    void constructorInjection_missingDependencies() {
        Throwable throwable = Assertions.catchThrowable(() -> Injector.getInstance().add(BeanWithConstructorInjection.class));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isInstanceOf(InjectorException.class)).hasMessage("No implementation found. Failed to inject org.jusecase.inject.classes.Driver arg0 in org.jusecase.inject.classes.BeanWithConstructorInjection");
    }

    @Test
    void subclass() {
        this.givenDependency(new TestDriverSubclass());
        TestGateway testGateway = new TestGateway();
        Assertions.assertThat((Object)testGateway.getDriver()).isInstanceOf(TestDriverSubclass.class);
    }

    @Test
    void subclassMock_noInjection() {
        DataSourceMock dataSourceMock = new DataSourceMock();
        Assertions.assertThat((String)dataSourceMock.getHostName()).isNull();
        Assertions.assertThat((String)dataSourceMock.getUserName()).isNull();
    }
}

