/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.inject;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import net.jodah.typetools.TypeResolver;
import org.jusecase.inject.InjectorException;
import org.jusecase.inject.PerClassProvider;

public class Injector {
    private static final Injector instance = new Injector();
    private static boolean unitTestMode;
    private Map<Class<?>, Object> implementations = new HashMap();
    private Map<Class<?>, Map<String, Object>> implementationsByName = new HashMap();
    private Map<Class<?>, List<Field>> injectableFields = new HashMap();

    public static Injector getInstance() {
        if (unitTestMode) {
            return UnitTestInstanceHolder.unitTestInstance.get();
        }
        return instance;
    }

    public void add(Object implementation) {
        this.add(implementation.getClass(), implementation);
    }

    public void add(String name, Object implementation) {
        this.add(name, implementation.getClass(), implementation);
    }

    public <T> void add(Class<T> implementationClass) {
        this.add(implementationClass, this.newInstance(implementationClass));
    }

    public <T> void add(String name, Class<T> implementationClass) {
        this.add(name, implementationClass, this.newInstance(implementationClass));
    }

    public <T extends Provider<?>> void addProvider(Class<T> providerClass) {
        this.addProvider((Provider)this.newInstance(providerClass));
    }

    public <T extends Provider<?>> void addProviderForSingleInstance(Class<T> providerClass) {
        this.addProviderForSingleInstance((Provider)this.newInstance(providerClass));
    }

    private <T> T newInstance(Class<T> clazz) {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            if (constructor.isAnnotationPresent(Inject.class)) {
                Object[] arguments = new Object[constructor.getParameterCount()];
                Parameter[] parameters = constructor.getParameters();
                int i = 0;
                while (i < parameters.length) {
                    arguments[i] = this.resolveImplementation(parameters[i].getType(), clazz);
                    if (arguments[i] == null) {
                        throw new InjectorException(this.createInjectErrorMessage("No implementation found.", clazz, parameters[i]));
                    }
                    ++i;
                }
                try {
                    return (T)constructor.newInstance(arguments);
                }
                catch (Throwable e) {
                    throw new InjectorException("Failed to create instance of " + clazz, e);
                }
            }
            ++n2;
        }
        try {
            return clazz.newInstance();
        }
        catch (Throwable e) {
            throw new InjectorException("Failed to create instance of " + clazz, e);
        }
    }

    public <T> void addProvider(Provider<T> provider) {
        Class providedClass = TypeResolver.resolveRawArguments(Provider.class, provider.getClass())[0];
        this.add(providedClass, provider);
        this.add(provider.getClass(), provider);
    }

    public <T> void addProviderForSingleInstance(Provider<T> provider) {
        Class providedClass = TypeResolver.resolveRawArguments(Provider.class, provider.getClass())[0];
        this.add(providedClass, provider.get());
        this.add(provider.getClass(), provider);
    }

    public <T> void addProvider(PerClassProvider<T> provider) {
        Class providedClass = TypeResolver.resolveRawArguments(PerClassProvider.class, provider.getClass())[0];
        this.add(providedClass, provider);
        this.add(provider.getClass(), provider);
    }

    private void add(Class<?> clazz, Object implementationOrProvider) {
        if (clazz.isAnnotationPresent(Named.class)) {
            Named named = clazz.getAnnotation(Named.class);
            if (named.value().isEmpty()) {
                this.add(clazz, implementationOrProvider, this.implementations::put);
            } else {
                this.add(named.value(), clazz);
            }
        } else {
            this.add(clazz, implementationOrProvider, this.implementations::put);
        }
    }

    private void add(String name, Class<?> clazz, Object implementationOrProvider) {
        this.add(clazz, implementationOrProvider, (Class<?> c, Object i) -> {
            Map implementationByName = this.implementationsByName.computeIfAbsent((Class<?>)c, key -> new HashMap());
            implementationByName.put(name, implementationOrProvider);
        });
    }

    private void add(Class<?> clazz, Object implementationOrProvider, BiConsumer<Class<?>, Object> consumer) {
        consumer.accept(clazz, implementationOrProvider);
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceClass = classArray[n2];
            consumer.accept(interfaceClass, implementationOrProvider);
            ++n2;
        }
        if (clazz.getSuperclass() != null) {
            this.add(clazz.getSuperclass(), implementationOrProvider, consumer);
        }
    }

    public <T> T resolve(Class<T> clazz) {
        return this.resolveImplementation(clazz, null);
    }

    public void inject(Object instance, Class declaringType) {
        for (Field field : this.getInjectableFields(declaringType)) {
            Object implementation = this.resolveImplementation(field, declaringType);
            if (implementation == null) {
                throw new InjectorException(this.createInjectErrorMessage("No implementation found.", declaringType, field));
            }
            if (Modifier.isFinal(field.getModifiers())) {
                throw new InjectorException(this.createInjectErrorMessage("@Inject field must not be final.", declaringType, field));
            }
            try {
                field.setAccessible(true);
                field.set(instance, implementation);
            }
            catch (IllegalAccessException e) {
                throw new InjectorException(this.createInjectErrorMessage("Failed to access field.", declaringType, field), e);
            }
        }
    }

    private String createInjectErrorMessage(String reason, Class type, Field field) {
        return String.valueOf(reason) + " Failed to inject " + field.getType().getName() + " " + field.getName() + " in " + type.getName();
    }

    private String createInjectErrorMessage(String reason, Class type, Parameter parameter) {
        return String.valueOf(reason) + " Failed to inject " + parameter.getType().getName() + " " + parameter.getName() + " in " + type.getName();
    }

    private <T> T resolveImplementation(Class<T> clazz, Class<?> toBeInjectedIn) {
        return (T)this.resolveImplementation(this.implementations.get(clazz), clazz, toBeInjectedIn);
    }

    private Object resolveImplementation(Field field, Class<?> toBeInjectedIn) {
        if (field.isAnnotationPresent(Named.class)) {
            String name = field.getAnnotation(Named.class).value();
            Map<String, Object> implementationByName = this.implementationsByName.get(field.getType());
            if (implementationByName == null) {
                throw new InjectorException(this.createInjectErrorMessage("No dependency named " + name + ".", toBeInjectedIn, field));
            }
            Object implementation = implementationByName.get(name);
            if (implementation == null) {
                TreeSet<String> available = new TreeSet<String>(implementationByName.keySet());
                throw new InjectorException(this.createInjectErrorMessage("No dependency named " + name + ", got " + available + ".", toBeInjectedIn, field));
            }
            return implementation;
        }
        return this.resolveImplementation(field.getType(), toBeInjectedIn);
    }

    private List<Field> getInjectableFields(Class<?> type) {
        List<Field> fields = this.injectableFields.get(type);
        if (fields == null) {
            fields = this.calculateInjectableFields(type);
            this.injectableFields.put(type, fields);
        }
        return fields;
    }

    private List<Field> calculateInjectableFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Field[] fieldArray = type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(Inject.class)) {
                fields.add(field);
            }
            ++n2;
        }
        return fields;
    }

    private Object resolveImplementation(Object implementation, Class<?> requestedClass, Class<?> toBeInjectedIn) {
        if (toBeInjectedIn != null && implementation instanceof PerClassProvider && !PerClassProvider.class.isAssignableFrom(requestedClass)) {
            return ((PerClassProvider)implementation).get(toBeInjectedIn);
        }
        if (implementation instanceof Provider && !Provider.class.isAssignableFrom(requestedClass)) {
            return ((Provider)implementation).get();
        }
        return implementation;
    }

    public void reset() {
        this.implementations.clear();
        this.implementationsByName.clear();
    }

    public static void enableUnitTestMode() {
        unitTestMode = true;
    }

    private static class UnitTestInstanceHolder {
        static final ThreadLocal<Injector> unitTestInstance = ThreadLocal.withInitial(Injector::new);

        private UnitTestInstanceHolder() {
        }
    }
}

