/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.inject;

import java.lang.reflect.Field;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.jusecase.inject.Injector;
import org.jusecase.inject.Trainer;

public interface ComponentTest {
    @BeforeEach
    default public void initInjector() {
        Injector.enableUnitTestMode();
        Injector.getInstance().setAllowMissingDependencies(true);
        this.injectFieldsDeclaredInTestClassAndSuperClasses(this.getClass());
    }

    default public void injectFieldsDeclaredInTestClassAndSuperClasses(Class<?> testClass) {
        if (testClass != Object.class) {
            this.injectFieldsDeclaredInTestClassAndSuperClasses(testClass.getSuperclass());
        }
        this.injectFieldsDeclaredInTestClass(testClass);
    }

    default public void injectFieldsDeclaredInTestClass(Class<?> testClass) {
        Field[] fieldArray = testClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Trainer trainer = field.getAnnotation(Trainer.class);
            if (trainer != null) {
                try {
                    field.setAccessible(true);
                    Object instance = field.get(this);
                    if (instance == null) {
                        instance = field.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
                        field.set(this, instance);
                    }
                    if (trainer.named().isEmpty()) {
                        this.givenDependency(instance);
                    } else {
                        this.givenDependency(trainer.named(), instance);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to inject field " + field.getName() + " in test class " + testClass.getSimpleName(), e);
                }
            }
            ++n2;
        }
    }

    @AfterEach
    default public void resetInjector() {
        Injector.getInstance().reset();
    }

    default public void givenDependency(Class<?> clazz) {
        Injector.getInstance().add(clazz);
    }

    default public void givenDependency(Object dependency) {
        Injector.getInstance().add(dependency);
    }

    default public void givenDependency(String name, Object dependency) {
        Injector.getInstance().add(name, dependency);
    }
}

