/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.inject;

import javax.inject.Inject;
import javax.inject.Named;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jusecase.inject.Component;
import org.jusecase.inject.ComponentTest;
import org.jusecase.inject.InjectorAspect;
import org.jusecase.inject.Trainer;

public class TrainerWithConstructorParamTest
implements ComponentTest {
    @Trainer
    private Gateway trainer = new Gateway("hello");
    @Trainer(named="name")
    private Gateway namedTrainer = new Gateway("hello named");

    @Test
    void injection() {
        Service service = new Service();
        Assertions.assertThat((Object)service.gateway).isSameAs((Object)this.trainer);
        Assertions.assertThat((String)this.trainer.source).isEqualTo((Object)"hello");
        Assertions.assertThat((Object)service.namedGateway).isSameAs((Object)this.namedTrainer);
        Assertions.assertThat((String)this.namedTrainer.source).isEqualTo((Object)"hello named");
    }

    public static class Gateway {
        private final String source;

        public Gateway(String source) {
            this.source = source;
        }
    }

    @Component
    public static class Service {
        @Inject
        public Gateway gateway;
        @Inject
        @Named(value="name")
        public Gateway namedGateway;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public Service() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            InjectorAspect.aspectOf().inject(joinPoint);
        }

        static {
            Service.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TrainerWithConstructorParamTest.java", Service.class);
            ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.jusecase.inject.TrainerWithConstructorParamTest$Service", "", "", ""), 33);
        }
    }
}

