/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.inject;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jusecase.inject.InjectorException;

public class GenericTypeResolver {
    public static Class<?> resolve(Type type, Class<?> clazz, int index) {
        Type[] genericInterfaces;
        Type[] typeArray = genericInterfaces = clazz.getGenericInterfaces();
        int n = genericInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterizedType parameterizedType;
            Type genericInterface = typeArray[n2];
            if (ParameterizedType.class.isAssignableFrom(genericInterface.getClass()) && (parameterizedType = (ParameterizedType)genericInterface).getRawType() == type) {
                return (Class)parameterizedType.getActualTypeArguments()[index];
            }
            ++n2;
        }
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
            return (Class)parameterizedType.getActualTypeArguments()[index];
        }
        if (genericSuperclass instanceof Class) {
            return GenericTypeResolver.resolve(type, (Class)genericSuperclass, index);
        }
        throw new InjectorException("Failed to resolve generic type " + type + " from class " + clazz + " at index " + index);
    }
}

