/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.maven;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jusecase.jte.CodeResolver;
import org.jusecase.jte.TemplateEngine;
import org.jusecase.jte.resolve.DirectoryCodeResolver;

@Mojo(name="precompile", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CompilerMojo
extends AbstractMojo {
    @Parameter
    public String sourceDirectory;
    @Parameter
    public String targetDirectory;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    public List<String> compilePath;
    @Parameter(readonly=true)
    public String[] htmlTags;
    @Parameter(readonly=true)
    public String[] htmlAttributes;

    public void execute() {
        Path source = Path.of(this.sourceDirectory, new String[0]);
        Path target = Path.of(this.targetDirectory, new String[0]);
        long start = System.nanoTime();
        this.getLog().info((CharSequence)("Precompiling jte templates found in " + source));
        TemplateEngine templateEngine = TemplateEngine.create((CodeResolver)new DirectoryCodeResolver(source), (Path)target);
        templateEngine.setHtmlTags(this.htmlTags);
        templateEngine.setHtmlAttributes(this.htmlAttributes);
        templateEngine.cleanAll();
        templateEngine.precompileAll(this.compilePath);
        long end = System.nanoTime();
        long duration = TimeUnit.NANOSECONDS.toSeconds(end - start);
        this.getLog().info((CharSequence)("Successfully precompiled jte templates in " + duration + "s to " + target));
    }
}

