/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.internal;

import java.util.function.Consumer;
import org.jusecase.jte.internal.ParameterParserVisitor;

final class ParameterParser {
    private final String code;
    private final ParameterParserVisitor visitor;
    private int lastIndex;

    public ParameterParser(String code, ParameterParserVisitor visitor) {
        this.code = code;
        this.visitor = visitor;
    }

    int parse() {
        this.parse("@import", this.visitor::onImport);
        this.parse("@param", this.visitor::onParameter);
        return this.lastIndex;
    }

    private void parse(String keyword, Consumer<String> callback) {
        int attributeEnd;
        int attributeStart;
        while ((attributeStart = this.code.indexOf(keyword, this.lastIndex)) != -1 && (attributeEnd = this.code.indexOf("\n", attributeStart)) != -1) {
            String parameter = this.code.substring(attributeStart + keyword.length(), attributeEnd).trim();
            callback.accept(parameter);
            this.lastIndex = attributeEnd + 1;
        }
    }
}

