/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jusecase.jte.CodeResolver;
import org.jusecase.jte.internal.ClassCompiler;
import org.jusecase.jte.internal.ClassDefinition;
import org.jusecase.jte.internal.ClassFilesCompiler;
import org.jusecase.jte.internal.EmptyTemplate;
import org.jusecase.jte.internal.IoUtils;
import org.jusecase.jte.internal.TagOrLayoutParameterParser;
import org.jusecase.jte.internal.Template;
import org.jusecase.jte.internal.TemplateParameterParser;
import org.jusecase.jte.internal.TemplateParser;
import org.jusecase.jte.internal.TemplateParserVisitor;
import org.jusecase.jte.internal.TemplateType;
import org.jusecase.jte.output.FileOutput;

public class TemplateCompiler {
    public static final String TAG_EXTENSION = ".jte";
    public static final String LAYOUT_EXTENSION = ".jte";
    public static final String TAG_DIRECTORY = "tag/";
    public static final String LAYOUT_DIRECTORY = "layout/";
    public static final String CLASS_PREFIX = "Jte";
    public static final String CLASS_SUFFIX = "Generated";
    private final CodeResolver codeResolver;
    private final Path classDirectory;
    private final String packageName;
    private final boolean debug = false;
    private final ConcurrentHashMap<String, LinkedHashSet<String>> templateDependencies = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<TagOrLayoutParameterParser.ParamInfo>> paramOrder = new ConcurrentHashMap();

    public TemplateCompiler(CodeResolver codeResolver, Path classDirectory) {
        this(codeResolver, "org.jusecase.jte", classDirectory);
    }

    public TemplateCompiler(CodeResolver codeResolver, String packageName, Path classDirectory) {
        this.codeResolver = codeResolver;
        this.classDirectory = classDirectory;
        this.packageName = packageName;
    }

    public Template<?> compile(String name) {
        if (this.classDirectory == null) {
            return this.compileInMemory(name);
        }
        return this.loadPrecompiled(name, true);
    }

    private Template<?> compileInMemory(String name) {
        LinkedHashSet<ClassDefinition> classDefinitions = new LinkedHashSet<ClassDefinition>();
        ClassDefinition templateDefinition = this.generateTemplate(name, classDefinitions);
        if (templateDefinition == null) {
            return EmptyTemplate.INSTANCE;
        }
        try {
            ClassCompiler classCompiler = new ClassCompiler();
            return (Template)classCompiler.compile(templateDefinition.getName(), classDefinitions).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Template<?> loadPrecompiled(String name, boolean firstAttempt) {
        try {
            ClassInfo templateInfo = new ClassInfo(name, this.packageName);
            URLClassLoader classLoader = new URLClassLoader(new URL[]{this.classDirectory.toUri().toURL()});
            return (Template)classLoader.loadClass(templateInfo.fullName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            if (firstAttempt) {
                this.precompile(List.of(name), null);
                return this.loadPrecompiled(name, false);
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanAll() {
        IoUtils.deleteDirectoryContent(this.classDirectory);
    }

    public void precompileAll(List<String> compilePath) {
        this.precompile(this.codeResolver.resolveAllTemplateNames(), compilePath);
    }

    public void precompile(List<String> names, List<String> compilePath) {
        LinkedHashSet<ClassDefinition> classDefinitions = new LinkedHashSet<ClassDefinition>();
        for (String name : names) {
            this.generateTemplate(name, classDefinitions);
        }
        for (ClassDefinition classDefinition : classDefinitions) {
            try (FileOutput fileOutput = new FileOutput(this.classDirectory.resolve(classDefinition.getJavaFileName()));){
                fileOutput.writeSafeContent(classDefinition.getCode());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        String[] files = new String[classDefinitions.size()];
        int i = 0;
        for (ClassDefinition classDefinition : classDefinitions) {
            files[i++] = this.classDirectory.resolve(classDefinition.getJavaFileName()).toFile().getAbsolutePath();
        }
        ClassFilesCompiler.compile(files, compilePath);
    }

    private ClassDefinition generateTemplate(String name, LinkedHashSet<ClassDefinition> classDefinitions) {
        String templateCode = this.codeResolver.resolve(name);
        if (templateCode == null) {
            throw new RuntimeException("No code found for template " + name);
        }
        if (templateCode.isEmpty()) {
            return null;
        }
        LinkedHashSet<String> templateDependencies = new LinkedHashSet<String>();
        ClassInfo templateInfo = new ClassInfo(name, this.packageName);
        TemplateParameterParser attributeParser = new TemplateParameterParser();
        attributeParser.parse(templateCode);
        StringBuilder javaCode = new StringBuilder("package " + templateInfo.packageName + ";\n");
        for (String importClass : attributeParser.importClasses) {
            javaCode.append("import ").append(importClass).append(";\n");
        }
        javaCode.append("public final class ").append(templateInfo.className).append(" implements org.jusecase.jte.internal.Template<").append(attributeParser.className).append("> {\n");
        javaCode.append("\tpublic void render(").append(attributeParser.className).append(" ").append(attributeParser.instanceName).append(", org.jusecase.jte.TemplateOutput output) {\n");
        new TemplateParser(TemplateType.Template).parse(attributeParser.lastIndex, templateCode, new CodeGenerator(TemplateType.Template, javaCode, classDefinitions, templateDependencies));
        javaCode.append("\t}\n");
        javaCode.append("}\n");
        this.templateDependencies.put(name, templateDependencies);
        ClassDefinition templateDefinition = new ClassDefinition(templateInfo.fullName);
        templateDefinition.setCode(javaCode.toString());
        classDefinitions.add(templateDefinition);
        return templateDefinition;
    }

    private ClassInfo generateTag(String name, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<String> templateDependencies) {
        return this.generateTagOrLayout(TemplateType.Tag, name, classDefinitions, templateDependencies);
    }

    private ClassInfo generateLayout(String name, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<String> templateDependencies) {
        return this.generateTagOrLayout(TemplateType.Layout, name, classDefinitions, templateDependencies);
    }

    private ClassInfo generateTagOrLayout(TemplateType type, String name, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<String> templateDependencies) {
        templateDependencies.add(name);
        ClassInfo classInfo = new ClassInfo(name, this.packageName);
        ClassDefinition classDefinition = new ClassDefinition(classInfo.fullName);
        if (classDefinitions.contains(classDefinition)) {
            return classInfo;
        }
        String code = this.codeResolver.resolve(name);
        if (code == null) {
            throw new RuntimeException("No code found for " + type + ": " + name);
        }
        classDefinitions.add(classDefinition);
        TagOrLayoutParameterParser parameterParser = new TagOrLayoutParameterParser();
        int lastIndex = parameterParser.parse(code);
        StringBuilder javaCode = new StringBuilder("package " + classInfo.packageName + ";\n");
        for (String importClass : parameterParser.importClasses) {
            javaCode.append("import ").append(importClass).append(";\n");
        }
        javaCode.append("public final class ").append(classInfo.className).append(" {\n");
        javaCode.append("\tpublic static void render(org.jusecase.jte.TemplateOutput output");
        for (TagOrLayoutParameterParser.ParamInfo parameter : parameterParser.parameters) {
            javaCode.append(", ").append(parameter.type).append(' ').append(parameter.name);
        }
        this.paramOrder.put(name, parameterParser.parameters);
        if (type == TemplateType.Layout) {
            javaCode.append(", java.util.function.Function<String, Runnable> jteLayoutDefinitionLookup");
        }
        javaCode.append(") {\n");
        new TemplateParser(type).parse(lastIndex, code, new CodeGenerator(type, javaCode, classDefinitions, templateDependencies));
        javaCode.append("\t}\n");
        javaCode.append("}\n");
        classDefinition.setCode(javaCode.toString());
        return classInfo;
    }

    public void clean(String name) {
        if (this.classDirectory == null) {
            return;
        }
        ClassInfo classInfo = new ClassInfo(name, this.packageName);
        ClassDefinition classDefinition = new ClassDefinition(classInfo.fullName);
        this.deleteFile(this.classDirectory.resolve(classDefinition.getJavaFileName()));
        this.deleteFile(this.classDirectory.resolve(classDefinition.getClassFileName()));
        this.paramOrder.remove(name);
    }

    private void deleteFile(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to delete file " + file, e);
        }
    }

    public List<String> getTemplatesUsing(String name) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, LinkedHashSet<String>> dependencies : this.templateDependencies.entrySet()) {
            if (!dependencies.getValue().contains(name)) continue;
            result.add(dependencies.getKey());
        }
        return result;
    }

    private static final class ParamCallInfo {
        final String name;
        final String data;

        public ParamCallInfo(String param) {
            param = param.trim();
            int nameEndIndex = -1;
            int dataStartIndex = -1;
            for (int i = 0; i < param.length(); ++i) {
                char character = param.charAt(i);
                if (nameEndIndex == -1) {
                    if (character == '\"' || character == '\'') break;
                    if (character != '=') continue;
                    nameEndIndex = i;
                    continue;
                }
                if (dataStartIndex != -1 || Character.isWhitespace(character)) continue;
                dataStartIndex = i;
            }
            if (nameEndIndex != -1 && dataStartIndex != -1) {
                this.name = param.substring(0, nameEndIndex).trim();
                this.data = param.substring(dataStartIndex).trim();
            } else {
                this.name = null;
                this.data = param;
            }
        }
    }

    private static final class ClassInfo {
        final String className;
        final String packageName;
        final String fullName;

        ClassInfo(String name, String parentPackage) {
            int startIndex;
            int endIndex = name.lastIndexOf(46);
            if (endIndex == -1) {
                endIndex = name.length();
            }
            startIndex = (startIndex = name.lastIndexOf(47)) == -1 ? 0 : ++startIndex;
            this.className = TemplateCompiler.CLASS_PREFIX + name.substring(startIndex, endIndex).replace("-", "") + TemplateCompiler.CLASS_SUFFIX;
            this.packageName = startIndex == 0 ? parentPackage : parentPackage + "." + name.substring(0, startIndex - 1).replace('/', '.');
            this.fullName = this.packageName + "." + this.className;
        }
    }

    private class CodeGenerator
    implements TemplateParserVisitor {
        private final TemplateType type;
        private final StringBuilder javaCode;
        private final LinkedHashSet<ClassDefinition> classDefinitions;
        private final LinkedHashSet<String> templateDependencies;

        private CodeGenerator(TemplateType type, StringBuilder javaCode, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<String> templateDependencies) {
            this.type = type;
            this.javaCode = javaCode;
            this.classDefinitions = classDefinitions;
            this.templateDependencies = templateDependencies;
        }

        @Override
        public void onTextPart(int depth, String textPart) {
            if (textPart.isEmpty()) {
                return;
            }
            this.writeIndentation(depth);
            this.javaCode.append("output.writeSafeContent(\"");
            this.appendEscaped(textPart);
            this.javaCode.append("\");\n");
        }

        @Override
        public void onCodePart(int depth, String codePart) {
            this.writeIndentation(depth);
            this.javaCode.append("output.writeUnsafe(").append(codePart).append(");\n");
        }

        @Override
        public void onSafeCodePart(int depth, String codePart) {
            this.writeIndentation(depth);
            this.javaCode.append("output.writeSafe(").append(codePart).append(");\n");
        }

        @Override
        public void onCodeStatement(int depth, String codePart) {
            this.writeIndentation(depth);
            this.javaCode.append(codePart).append(";\n");
        }

        @Override
        public void onConditionStart(int depth, String condition) {
            this.writeIndentation(depth);
            this.javaCode.append("if (").append(condition).append(") {\n");
        }

        @Override
        public void onConditionElse(int depth, String condition) {
            this.writeIndentation(depth);
            this.javaCode.append("} else if (").append(condition).append(") {\n");
        }

        @Override
        public void onConditionElse(int depth) {
            this.writeIndentation(depth);
            this.javaCode.append("} else {\n");
        }

        @Override
        public void onConditionEnd(int depth) {
            this.writeIndentation(depth);
            this.javaCode.append("}\n");
        }

        @Override
        public void onForLoopStart(int depth, String codePart) {
            this.writeIndentation(depth);
            this.javaCode.append("for (").append(codePart).append(") {\n");
        }

        @Override
        public void onForLoopEnd(int depth) {
            this.writeIndentation(depth);
            this.javaCode.append("}\n");
        }

        @Override
        public void onTag(int depth, String name, List<String> params) {
            String tagName = TemplateCompiler.TAG_DIRECTORY + name.replace('.', '/') + ".jte";
            ClassInfo tagInfo = TemplateCompiler.this.generateTag(tagName, this.classDefinitions, this.templateDependencies);
            this.writeIndentation(depth);
            this.javaCode.append(tagInfo.fullName).append(".render(output");
            this.appendParams(tagName, params);
            this.javaCode.append(");\n");
        }

        @Override
        public void onLayout(int depth, String name, List<String> params) {
            String layoutName = TemplateCompiler.LAYOUT_DIRECTORY + name.replace('.', '/') + ".jte";
            ClassInfo layoutInfo = TemplateCompiler.this.generateLayout(layoutName, this.classDefinitions, this.templateDependencies);
            this.writeIndentation(depth);
            this.javaCode.append(layoutInfo.fullName).append(".render(output");
            this.appendParams(layoutName, params);
            this.javaCode.append(", new java.util.function.Function<String, Runnable>() {\n");
            this.writeIndentation(depth + 1);
            this.javaCode.append("public Runnable apply(String jteLayoutDefinition) {\n");
        }

        private void appendParams(String name, List<String> params) {
            List<TagOrLayoutParameterParser.ParamInfo> paramInfos = TemplateCompiler.this.paramOrder.get(name);
            if (paramInfos == null) {
                throw new IllegalStateException("No parameter information for " + name);
            }
            if (paramInfos.isEmpty()) {
                return;
            }
            int index = 0;
            ParamCallInfo[] paramCallInfos = new ParamCallInfo[paramInfos.size()];
            for (String param : params) {
                ParamCallInfo paramCallInfo = new ParamCallInfo(param);
                int parameterIndex = this.getParameterIndex(name, paramInfos, paramCallInfo);
                if (parameterIndex == -1) {
                    parameterIndex = index;
                }
                paramCallInfos[parameterIndex] = paramCallInfo;
                ++index;
            }
            for (int i = 0; i < paramCallInfos.length; ++i) {
                ParamCallInfo paramCallInfo = paramCallInfos[i];
                if (paramCallInfo != null) {
                    this.javaCode.append(", ").append(paramCallInfo.data);
                    continue;
                }
                TagOrLayoutParameterParser.ParamInfo paramInfo = paramInfos.get(i);
                if (paramInfo.defaultValue == null) continue;
                this.javaCode.append(", ").append(paramInfo.defaultValue);
            }
        }

        private int getParameterIndex(String name, List<TagOrLayoutParameterParser.ParamInfo> paramInfos, ParamCallInfo paramCallInfo) {
            if (paramCallInfo.name == null) {
                return -1;
            }
            for (int i = 0; i < paramInfos.size(); ++i) {
                if (!paramInfos.get((int)i).name.equals(paramCallInfo.name)) continue;
                return i;
            }
            throw new IllegalStateException("No parameter with name " + paramCallInfo.name + " is defined in " + name);
        }

        @Override
        public void onLayoutRender(int depth, String name) {
            this.writeIndentation(depth);
            this.javaCode.append("jteLayoutDefinitionLookup.apply(\"").append(name.trim()).append("\").run();\n");
        }

        @Override
        public void onLayoutDefine(int depth, String name) {
            this.writeIndentation(depth + 2);
            this.javaCode.append("if (\"").append(name.trim()).append("\".equals(jteLayoutDefinition)) {\n");
            this.writeIndentation(depth + 3);
            this.javaCode.append("return new Runnable() {\n");
            this.writeIndentation(depth + 4);
            this.javaCode.append("public void run() {\n");
        }

        @Override
        public void onLayoutDefineEnd(int depth) {
            this.writeIndentation(depth + 4);
            this.javaCode.append("}\n");
            this.writeIndentation(depth + 3);
            this.javaCode.append("};\n");
            this.writeIndentation(depth + 2);
            this.javaCode.append("}\n");
        }

        @Override
        public void onLayoutEnd(int depth) {
            this.writeIndentation(depth + 2);
            if (this.type == TemplateType.Layout) {
                this.javaCode.append("return jteLayoutDefinitionLookup.apply(jteLayoutDefinition);\n");
            } else {
                this.javaCode.append("return () -> {};\n");
            }
            this.writeIndentation(depth + 1);
            this.javaCode.append("}\n");
            this.writeIndentation(depth);
            this.javaCode.append("});\n");
        }

        private void writeIndentation(int depth) {
            for (int i = 0; i < depth + 2; ++i) {
                this.javaCode.append('\t');
            }
        }

        private void appendEscaped(String text) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\"') {
                    this.javaCode.append("\\\"");
                    continue;
                }
                if (c == '\n') {
                    this.javaCode.append("\\n");
                    continue;
                }
                if (c == '\t') {
                    this.javaCode.append("\\t");
                    continue;
                }
                if (c == '\r') {
                    this.javaCode.append("\\r");
                    continue;
                }
                if (c == '\f') {
                    this.javaCode.append("\\f");
                    continue;
                }
                if (c == '\b') {
                    this.javaCode.append("\\b");
                    continue;
                }
                if (c == '\\') {
                    this.javaCode.append("\\\\");
                    continue;
                }
                this.javaCode.append(c);
            }
        }
    }
}

