/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jusecase.jte.CodeResolver;
import org.jusecase.jte.TemplateOutput;
import org.jusecase.jte.internal.Template;
import org.jusecase.jte.internal.TemplateCompiler;

public final class TemplateEngine {
    private final TemplateCompiler compiler;
    private final ConcurrentMap<String, Template> templateCache;

    public TemplateEngine(CodeResolver codeResolver) {
        this(codeResolver, null);
    }

    public TemplateEngine(CodeResolver codeResolver, Path classDirectory) {
        this.compiler = new TemplateCompiler(codeResolver, classDirectory);
        this.templateCache = new ConcurrentHashMap<String, Template>();
    }

    public void render(String name, Object model, TemplateOutput output) {
        Template template = this.resolveTemplate(name);
        template.render(model, output);
    }

    public List<String> invalidate(String name) {
        if (name.startsWith("tag/") || name.startsWith("layout/")) {
            this.templateCache.compute(name, (n, t) -> {
                this.compiler.clean(name);
                return null;
            });
            List<String> templateNames = this.compiler.getTemplatesUsing(name);
            for (String templateName : templateNames) {
                this.invalidate(templateName);
            }
            return templateNames;
        }
        this.templateCache.compute(name, (n, t) -> {
            this.compiler.clean(name);
            return null;
        });
        return Collections.singletonList(name);
    }

    public void prepareForRendering(String name) {
        this.resolveTemplate(name);
    }

    public void cleanAll() {
        this.compiler.cleanAll();
    }

    public void precompileAll() {
        this.precompileAll(null);
    }

    public void precompileAll(List<String> compilePath) {
        this.compiler.precompileAll(compilePath);
    }

    private Template resolveTemplate(String name) {
        return this.templateCache.computeIfAbsent(name, this.compiler::compile);
    }

    public void setNullSafeTemplateCode(boolean value) {
        this.compiler.setNullSafeTemplateCode(value);
    }
}

