/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.jusecase.jte.internal.ClassDefinition;

final class ClassCompiler {
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final ClassFileManager fileManager = new ClassFileManager(this.compiler.getStandardFileManager(null, null, null));
    private final ByteArrayClassLoader classLoader = new ByteArrayClassLoader();
    private final Map<String, JavaFileObject> fileObjectMap = new HashMap<String, JavaFileObject>();

    ClassCompiler() {
    }

    Class<?> compile(String name, LinkedHashSet<ClassDefinition> classDefinitions) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        ClassLoader cl = lookup.lookupClass().getClassLoader();
        StringWriter out = new StringWriter();
        try {
            ArrayList<CharSequenceJavaFileObject> files = new ArrayList<CharSequenceJavaFileObject>();
            for (ClassDefinition classDefinition : classDefinitions) {
                files.add(new CharSequenceJavaFileObject(classDefinition.getName(), classDefinition.getCode()));
            }
            StringBuilder classpath = new StringBuilder();
            String separator = System.getProperty("path.separator");
            String prop = System.getProperty("java.class.path");
            if (prop != null && !"".equals(prop)) {
                classpath.append(prop);
            }
            if (cl instanceof URLClassLoader) {
                for (URL url : ((URLClassLoader)cl).getURLs()) {
                    if (classpath.length() > 0) {
                        classpath.append(separator);
                    }
                    if (!"file".equals(url.getProtocol())) continue;
                    classpath.append(new File(url.toURI()));
                }
            }
            ArrayList<String> options = new ArrayList<String>(Arrays.asList("-classpath", classpath.toString()));
            JavaCompiler.CompilationTask task = this.compiler.getTask(out, this.fileManager, null, options, null, files);
            task.call();
            if (this.fileManager.isEmpty()) {
                throw new RuntimeException("Compilation error: " + out);
            }
            return this.classLoader.loadClass(name);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while compiling: " + out, e);
        }
    }

    static final class CharSequenceJavaFileObject
    extends SimpleJavaFileObject {
        final CharSequence content;

        public CharSequenceJavaFileObject(String className, CharSequence content) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.content = content;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.content;
        }
    }

    final class ClassFileManager
    extends ForwardingJavaFileManager<StandardJavaFileManager> {
        ClassFileManager(StandardJavaFileManager standardManager) {
            super(standardManager);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
            JavaFileObject result = new JavaFileObject(className, kind);
            ClassCompiler.this.fileObjectMap.put(className, result);
            return result;
        }

        boolean isEmpty() {
            return ClassCompiler.this.fileObjectMap.isEmpty();
        }
    }

    static final class JavaFileObject
    extends SimpleJavaFileObject {
        final ByteArrayOutputStream os = new ByteArrayOutputStream();

        JavaFileObject(String name, JavaFileObject.Kind kind) {
            super(URI.create("string:///" + name.replace('.', '/') + kind.extension), kind);
        }

        byte[] getBytes() {
            return this.os.toByteArray();
        }

        @Override
        public OutputStream openOutputStream() {
            return this.os;
        }
    }

    final class ByteArrayClassLoader
    extends ClassLoader {
        ByteArrayClassLoader() {
        }

        @Override
        protected Class<?> findClass(String name) {
            JavaFileObject fileObject = ClassCompiler.this.fileObjectMap.get(name);
            if (fileObject == null) {
                throw new RuntimeException("No class found for " + name);
            }
            byte[] bytes = fileObject.getBytes();
            return this.defineClass(name, bytes, 0, bytes.length);
        }
    }
}

