/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;

public final class IoUtils {
    public static String toString(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(StandardCharsets.UTF_8);
    }

    public static void deleteDirectoryContent(Path directory) {
        if (!Files.exists(directory, new LinkOption[0])) {
            return;
        }
        try {
            Files.walk(directory, new FileVisitOption[0]).filter(d -> d != directory).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] getUtf8Bytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static int getUtf8Length(String string) {
        int result = 0;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                ++result;
                continue;
            }
            if (c < '\u0800') {
                result += 2;
                continue;
            }
            if (Character.isSurrogate(c)) {
                result += 4;
                ++i;
                continue;
            }
            result += 3;
        }
        return result;
    }

    public static void writeUtf8(String string, OutputStream outputStream) throws IOException {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                outputStream.write((byte)c);
                continue;
            }
            if (c < '\u0800') {
                outputStream.write((byte)(0xC0 | c >> 6));
                outputStream.write((byte)(0x80 | c & 0x3F));
                continue;
            }
            if (Character.isSurrogate(c)) {
                int cp = Character.toCodePoint(c, string.charAt(++i));
                outputStream.write((byte)(0xF0 | cp >> 18));
                outputStream.write((byte)(0x80 | cp >> 12 & 0x3F));
                outputStream.write((byte)(0x80 | cp >> 6 & 0x3F));
                outputStream.write((byte)(0x80 | cp & 0x3F));
                continue;
            }
            outputStream.write((byte)(0xE0 | c >> 12));
            outputStream.write((byte)(0x80 | c >> 6 & 0x3F));
            outputStream.write((byte)(0x80 | c & 0x3F));
        }
    }
}

