/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.output;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jusecase.jte.TemplateOutput;
import org.jusecase.jte.internal.IoUtils;

public final class Utf8FileOutput
implements TemplateOutput,
Closeable {
    private final OutputStream outputStream;

    public Utf8FileOutput(Path file) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        this.outputStream = Files.newOutputStream(file, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
    }

    @Override
    public void writeSafeContent(String value) {
        try {
            IoUtils.writeUtf8(value, this.outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeStaticContent(String value, byte[] bytes) {
        try {
            this.outputStream.write(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

