/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.jusecase.jte.internal.ParamInfo;
import org.jusecase.jte.internal.TemplateParserVisitor;
import org.jusecase.jte.internal.TemplateType;

final class TemplateParser {
    private static final int LAYOUT_DEFINITION_DEPTH = 4;
    private final TemplateType type;
    private final TemplateParserVisitor visitor;
    private final Deque<Mode> stack = new ArrayDeque<Mode>();
    private Mode currentMode;
    private int depth;
    private boolean paramsComplete;

    TemplateParser(TemplateType type, TemplateParserVisitor visitor) {
        this.type = type;
        this.visitor = visitor;
    }

    public void parse(String templateCode) {
        int lastIndex = 0;
        char previousChar7 = '\u0000';
        char previousChar6 = '\u0000';
        char previousChar5 = '\u0000';
        char previousChar4 = '\u0000';
        char previousChar3 = '\u0000';
        char previousChar2 = '\u0000';
        char previousChar1 = '\u0000';
        char previousChar0 = '\u0000';
        char currentChar = '\u0000';
        this.currentMode = Mode.Text;
        this.stack.push(this.currentMode);
        this.depth = 0;
        for (int i = 0; i < templateCode.length(); ++i) {
            TagOrLayoutMode previousMode;
            char previousChar8 = previousChar7;
            previousChar7 = previousChar6;
            previousChar6 = previousChar5;
            previousChar5 = previousChar4;
            previousChar4 = previousChar3;
            previousChar3 = previousChar2;
            previousChar2 = previousChar1;
            previousChar1 = previousChar0;
            previousChar0 = currentChar;
            currentChar = templateCode.charAt(i);
            if (previousChar5 == '@' && previousChar4 == 'i' && previousChar3 == 'm' && previousChar2 == 'p' && previousChar1 == 'o' && previousChar0 == 'r' && currentChar == 't') {
                this.push(Mode.Import);
                lastIndex = i + 1;
            } else if (this.currentMode == Mode.Import && currentChar == '\n') {
                this.extract(templateCode, lastIndex, i, (depth, content) -> this.visitor.onImport(content.trim()));
                this.pop();
                lastIndex = i + 1;
            } else if (previousChar4 == '@' && previousChar3 == 'p' && previousChar2 == 'a' && previousChar1 == 'r' && previousChar0 == 'a' && currentChar == 'm') {
                this.push(Mode.Param);
                lastIndex = i + 1;
            } else if (this.currentMode == Mode.Param && currentChar == '\n') {
                this.extract(templateCode, lastIndex, i, (depth, content) -> this.visitor.onParam(new ParamInfo(content.trim())));
                this.pop();
                lastIndex = i + 1;
            } else if (this.currentMode != Mode.Comment && previousChar2 == '<' && previousChar1 == '%' && previousChar0 == '-' && currentChar == '-') {
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i - 3, this.visitor::onTextPart);
                }
                this.push(Mode.Comment);
            } else if (this.currentMode == Mode.Comment) {
                if (previousChar2 == '-' && previousChar1 == '-' && previousChar0 == '%' && currentChar == '>') {
                    this.pop();
                    lastIndex = i + 1;
                }
            } else if (previousChar0 == '$' && currentChar == '{') {
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i - 1, this.visitor::onTextPart);
                }
                lastIndex = i + 1;
                this.push(Mode.Code);
            } else if (previousChar4 == '$' && previousChar3 == 's' && previousChar2 == 'a' && previousChar1 == 'f' && previousChar0 == 'e' && currentChar == '{') {
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i - 5, this.visitor::onTextPart);
                }
                lastIndex = i + 1;
                this.push(Mode.SafeCode);
            } else if (previousChar0 == '!' && currentChar == '{') {
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i - 1, this.visitor::onTextPart);
                }
                lastIndex = i + 1;
                this.push(Mode.CodeStatement);
            } else if (currentChar == '}' && this.currentMode == Mode.CodeStatement) {
                this.pop();
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i, this.visitor::onCodeStatement);
                    lastIndex = i + 1;
                }
            } else if (currentChar == '\"' && this.currentMode.isJava()) {
                this.push(Mode.JavaCodeString);
            } else if (currentChar == '\"' && this.currentMode == Mode.JavaCodeString && previousChar0 != '\\') {
                this.pop();
            } else if (currentChar == '}' && this.currentMode == Mode.Code) {
                this.pop();
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i, this.visitor::onCodePart);
                    lastIndex = i + 1;
                }
            } else if (currentChar == '}' && this.currentMode == Mode.SafeCode) {
                this.pop();
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i, this.visitor::onSafeCodePart);
                    lastIndex = i + 1;
                }
            } else if (previousChar1 == '@' && previousChar0 == 'i' && currentChar == 'f') {
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i - 2, this.visitor::onTextPart);
                    lastIndex = i + 1;
                }
                this.push(Mode.Condition);
            } else if (currentChar == '(' && (this.currentMode == Mode.Condition || this.currentMode == Mode.ConditionElse)) {
                lastIndex = i + 1;
                this.push(Mode.JavaCode);
            } else if (currentChar == '(' && this.currentMode.isJava()) {
                this.push(Mode.JavaCode);
            } else if (currentChar == ')' && this.currentMode.isJava()) {
                if (this.currentMode == Mode.JavaCodeParam) {
                    previousMode = this.getPreviousMode(TagOrLayoutMode.class);
                    this.extract(templateCode, lastIndex, i, (d, c) -> {
                        if (c != null && !c.isBlank()) {
                            previousMode.params.add(c);
                        }
                    });
                }
                this.pop();
                if (this.currentMode == Mode.Condition) {
                    this.extract(templateCode, lastIndex, i, this.visitor::onConditionStart);
                    lastIndex = i + 1;
                    this.push(Mode.Text);
                } else if (this.currentMode == Mode.ConditionElse) {
                    this.extract(templateCode, lastIndex, i, this.visitor::onConditionElse);
                    lastIndex = i + 1;
                    this.push(Mode.Text);
                } else if (this.currentMode instanceof TagMode) {
                    TagMode tagMode = (TagMode)this.currentMode;
                    this.extract(templateCode, lastIndex, i, (d, c) -> this.visitor.onTag(d, tagMode.name.toString(), tagMode.params));
                    lastIndex = i + 1;
                    this.pop();
                } else if (this.currentMode instanceof LayoutMode) {
                    LayoutMode layoutMode = (LayoutMode)this.currentMode;
                    this.extract(templateCode, lastIndex, i, (d, c) -> this.visitor.onLayout(d, layoutMode.name.toString(), layoutMode.params));
                }
            } else if (currentChar == ',' && this.currentMode == Mode.JavaCodeParam) {
                previousMode = this.getPreviousMode(TagOrLayoutMode.class);
                this.extract(templateCode, lastIndex, i, (d, c) -> {
                    if (c != null && !c.isBlank()) {
                        previousMode.params.add(c);
                    }
                });
                lastIndex = i + 1;
            } else if (previousChar3 == '@' && previousChar2 == 'e' && previousChar1 == 'l' && previousChar0 == 's' && currentChar == 'e' && templateCode.charAt(i + 1) != 'i') {
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i - 4, this.visitor::onTextPart);
                }
                lastIndex = i + 1;
                this.pop();
                this.visitor.onConditionElse(this.depth);
                this.push(Mode.Text);
            } else if (previousChar5 == '@' && previousChar4 == 'e' && previousChar3 == 'l' && previousChar2 == 's' && previousChar1 == 'e' && previousChar0 == 'i' && currentChar == 'f') {
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i - 6, this.visitor::onTextPart);
                }
                lastIndex = i + 1;
                this.pop();
                if (this.currentMode == Mode.Condition || this.currentMode == Mode.ConditionElse) {
                    this.pop();
                }
                this.push(Mode.ConditionElse);
            } else if (previousChar4 == '@' && previousChar3 == 'e' && previousChar2 == 'n' && previousChar1 == 'd' && previousChar0 == 'i' && currentChar == 'f') {
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i - 5, this.visitor::onTextPart);
                }
                lastIndex = i + 1;
                this.pop();
                if (this.currentMode == Mode.Condition || this.currentMode == Mode.ConditionElse) {
                    this.visitor.onConditionEnd(this.depth);
                    this.pop();
                }
            } else if (previousChar2 == '@' && previousChar1 == 'f' && previousChar0 == 'o' && currentChar == 'r') {
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i - 3, this.visitor::onTextPart);
                    lastIndex = i + 1;
                }
                this.push(Mode.ForLoop);
            } else if (currentChar == '(' && this.currentMode == Mode.ForLoop) {
                lastIndex = i + 1;
                this.push(Mode.ForLoopCode);
            } else if (currentChar == '(' && this.currentMode == Mode.ForLoopCode) {
                this.push(Mode.ForLoopCode);
            } else if (currentChar == ')' && this.currentMode == Mode.ForLoopCode) {
                this.pop();
                if (this.currentMode == Mode.ForLoop) {
                    this.extract(templateCode, lastIndex, i, this.visitor::onForLoopStart);
                    lastIndex = i + 1;
                    this.push(Mode.Text);
                }
            } else if (previousChar5 == '@' && previousChar4 == 'e' && previousChar3 == 'n' && previousChar2 == 'd' && previousChar1 == 'f' && previousChar0 == 'o' && currentChar == 'r') {
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i - 6, this.visitor::onTextPart);
                }
                lastIndex = i + 1;
                this.pop();
                if (this.currentMode == Mode.ForLoop) {
                    this.visitor.onForLoopEnd(this.depth);
                    this.pop();
                }
            } else if (previousChar3 == '@' && previousChar2 == 't' && previousChar1 == 'a' && previousChar0 == 'g' && currentChar == '.') {
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i - 4, this.visitor::onTextPart);
                    lastIndex = i + 1;
                }
                this.push(new TagMode());
                this.push(Mode.TagName);
            } else if (this.currentMode == Mode.TagName) {
                if (currentChar == '(') {
                    this.pop();
                    this.push(Mode.JavaCodeParam);
                    lastIndex = i + 1;
                } else if (currentChar != ' ') {
                    this.getPreviousMode(TagOrLayoutMode.class).name.append(currentChar);
                }
            } else if (previousChar6 == '@' && previousChar5 == 'l' && previousChar4 == 'a' && previousChar3 == 'y' && previousChar2 == 'o' && previousChar1 == 'u' && previousChar0 == 't' && currentChar == '.') {
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i - 7, this.visitor::onTextPart);
                    lastIndex = i + 1;
                }
                this.push(new LayoutMode());
                this.push(Mode.TagName);
            } else if (previousChar8 == '@' && previousChar7 == 'e' && previousChar6 == 'n' && previousChar5 == 'd' && previousChar4 == 'l' && previousChar3 == 'a' && previousChar2 == 'y' && previousChar1 == 'o' && previousChar0 == 'u' && currentChar == 't') {
                this.pop();
                lastIndex = i + 1;
                this.visitor.onLayoutEnd(this.depth);
            } else if (previousChar5 == '@' && previousChar4 == 'd' && previousChar3 == 'e' && previousChar2 == 'f' && previousChar1 == 'i' && previousChar0 == 'n' && currentChar == 'e') {
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i - 6, this.visitor::onTextPart);
                    lastIndex = i + 1;
                }
                this.push(Mode.LayoutDefine);
            } else if (currentChar == '(' && this.currentMode == Mode.LayoutDefine) {
                lastIndex = i + 1;
            } else if (currentChar == ')' && this.currentMode == Mode.LayoutDefine) {
                this.extract(templateCode, lastIndex, i, this.visitor::onLayoutDefine);
                lastIndex = i + 1;
                this.push(Mode.Text);
                this.depth += 4;
            } else if (previousChar8 == '@' && previousChar7 == 'e' && previousChar6 == 'n' && previousChar5 == 'd' && previousChar4 == 'd' && previousChar3 == 'e' && previousChar2 == 'f' && previousChar1 == 'i' && previousChar0 == 'n' && currentChar == 'e') {
                if (this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i - 9, this.visitor::onTextPart);
                }
                this.pop();
                this.pop();
                this.depth -= 4;
                lastIndex = i + 1;
                this.visitor.onLayoutDefineEnd(this.depth);
            } else if (previousChar5 == '@' && previousChar4 == 'r' && previousChar3 == 'e' && previousChar2 == 'n' && previousChar1 == 'd' && previousChar0 == 'e' && currentChar == 'r') {
                if (this.type == TemplateType.Layout && this.currentMode == Mode.Text) {
                    this.extract(templateCode, lastIndex, i - 6, this.visitor::onTextPart);
                    lastIndex = i + 1;
                }
                this.push(Mode.LayoutRender);
            } else if (currentChar == '(' && this.currentMode == Mode.LayoutRender) {
                lastIndex = i + 1;
            } else if (currentChar == ')' && this.currentMode == Mode.LayoutRender) {
                this.extract(templateCode, lastIndex, i, this.visitor::onLayoutRender);
                lastIndex = i + 1;
                this.pop();
            }
            if (currentChar != '\n') continue;
            this.visitor.onLineFinished();
        }
        if (lastIndex < templateCode.length()) {
            this.extract(templateCode, lastIndex, templateCode.length(), this.visitor::onTextPart);
        }
        this.completeParamsIfRequired();
        this.visitor.onComplete();
    }

    private void push(Mode mode) {
        this.currentMode = mode;
        this.stack.push(this.currentMode);
        if (mode == Mode.Text) {
            ++this.depth;
        }
    }

    private void pop() {
        Mode previousMode = this.stack.pop();
        if (previousMode == Mode.Text) {
            --this.depth;
        }
        this.currentMode = this.stack.peek();
    }

    private <T extends Mode> T getPreviousMode(Class<T> modeClass) {
        for (Mode mode : this.stack) {
            if (!modeClass.isAssignableFrom(mode.getClass())) continue;
            return (T)mode;
        }
        throw new IllegalStateException("Expected mode of type " + modeClass + " on the stack, but found nothing!");
    }

    private void extract(String templateCode, int startIndex, int endIndex, VisitorCallback callback) {
        this.completeParamsIfRequired();
        if (startIndex < 0) {
            return;
        }
        if (endIndex < startIndex) {
            return;
        }
        callback.accept(this.depth, templateCode.substring(startIndex, endIndex));
    }

    private void completeParamsIfRequired() {
        if (!this.paramsComplete && this.currentMode != Mode.Param && this.currentMode != Mode.Import) {
            this.visitor.onParamsComplete();
            this.paramsComplete = true;
        }
    }

    private static class LayoutMode
    extends TagOrLayoutMode {
        private LayoutMode() {
        }
    }

    private static class TagMode
    extends TagOrLayoutMode {
        private TagMode() {
        }
    }

    private static abstract class TagOrLayoutMode
    implements Mode {
        final StringBuilder name = new StringBuilder();
        final List<String> params = new ArrayList<String>();

        private TagOrLayoutMode() {
        }

        @Override
        public boolean isJava() {
            return false;
        }
    }

    private static class StatelessMode
    implements Mode {
        private final boolean java;

        private StatelessMode() {
            this(false);
        }

        private StatelessMode(boolean java) {
            this.java = java;
        }

        @Override
        public boolean isJava() {
            return this.java;
        }
    }

    private static interface Mode {
        public static final Mode Import = new StatelessMode();
        public static final Mode Param = new StatelessMode();
        public static final Mode Text = new StatelessMode();
        public static final Mode Code = new StatelessMode();
        public static final Mode SafeCode = new StatelessMode();
        public static final Mode CodeStatement = new StatelessMode();
        public static final Mode Condition = new StatelessMode();
        public static final Mode JavaCode = new StatelessMode(true);
        public static final Mode JavaCodeParam = new StatelessMode(true);
        public static final Mode JavaCodeString = new StatelessMode();
        public static final Mode ConditionElse = new StatelessMode();
        public static final Mode ForLoop = new StatelessMode();
        public static final Mode ForLoopCode = new StatelessMode();
        public static final Mode TagName = new StatelessMode();
        public static final Mode LayoutDefine = new StatelessMode();
        public static final Mode LayoutRender = new StatelessMode();
        public static final Mode Comment = new StatelessMode();

        public boolean isJava();
    }

    static interface VisitorCallback {
        public void accept(int var1, String var2);
    }
}

