/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.resolve;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jusecase.jte.CodeResolver;
import org.jusecase.jte.TemplateEngine;

public class DirectoryCodeResolver
implements CodeResolver {
    private final Path root;
    private Thread reloadThread;

    public DirectoryCodeResolver(Path root) {
        this.root = root;
    }

    @Override
    public String resolve(String name) {
        try {
            return Files.readString(this.root.resolve(name));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public List<String> resolveAllTemplateNames() {
        List<String> list;
        block8: {
            Stream<Path> stream = Files.walk(this.root, new FileVisitOption[0]);
            try {
                list = stream.filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(p -> this.root.relativize((Path)p).toString().replace('\\', '/')).filter(s -> !s.startsWith("tag/") && !s.startsWith("layout/")).filter(s -> s.endsWith(".jte")).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to resolve all templates in " + this.root, e);
                }
            }
            stream.close();
        }
        return list;
    }

    public void enableHotReload(TemplateEngine templateEngine, Consumer<List<String>> onTemplatesInvalidated) {
        this.reloadThread = new Thread(() -> this.enableHotReloadBlocking(templateEngine, onTemplatesInvalidated));
        this.reloadThread.setName("jte-reloader");
        this.reloadThread.setDaemon(true);
        this.reloadThread.start();
    }

    public void stopHotReload() {
        this.reloadThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableHotReloadBlocking(TemplateEngine templateEngine, Consumer<List<String>> onTemplatesInvalidated) {
        try (WatchService watchService = FileSystems.getDefault().newWatchService();){
            WatchKey watchKey;
            Files.walk(this.root, new FileVisitOption[0]).filter(p -> Files.isDirectory(p, new LinkOption[0])).forEach(p -> {
                try {
                    p.register(watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to register watch service for hot reload!", e);
                }
            });
            while ((watchKey = watchService.take()) != null) {
                try {
                    List<WatchEvent<?>> events = watchKey.pollEvents();
                    for (WatchEvent<?> event : events) {
                        Path file;
                        Path absoluteFile;
                        String eventContext = event.context().toString();
                        if (!eventContext.endsWith(".jte") || (absoluteFile = this.root.resolve(file = this.root.relativize((Path)watchKey.watchable()).resolve(eventContext))).toFile().length() <= 0L) continue;
                        String name = file.toString().replace('\\', '/');
                        List<String> invalidatedTemplates = templateEngine.invalidate(name);
                        if (onTemplatesInvalidated == null) continue;
                        onTemplatesInvalidated.accept(invalidatedTemplates);
                    }
                }
                finally {
                    watchKey.reset();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to watch page content", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

