/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jusecase.jte.TemplateOutput;
import org.jusecase.jte.internal.IoUtils;

public final class Utf8ArrayOutput
implements TemplateOutput {
    private final List<Object> result = new ArrayList<Object>();
    private int contentLength;

    public int getContentLength() {
        return this.contentLength;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        for (Object data : this.result) {
            if (data instanceof byte[]) {
                outputStream.write((byte[])data);
                continue;
            }
            IoUtils.writeUtf8((String)data, outputStream);
        }
    }

    @Override
    public void writeStaticContent(String value, byte[] bytes) {
        this.result.add(bytes);
        this.contentLength += bytes.length;
    }

    @Override
    public void writeContent(String value) {
        this.result.add(value);
        this.contentLength += IoUtils.getUtf8Length(value);
    }
}

